/***********************************************************************/
/*    Function Block 1: AI-- 1                               */
/***********************************************************************/

BLOCK func1_AI_1
{
    TYPE    FUNCTION;
    NUMBER  1;
}

func1_AI_1_blk_reserve                        LIKE VARIABLE    phys_blk_reserve
{
}

VARIABLE func1_AI_1_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [blk_block_object_FUNCTION]        }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_1_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [func_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    1,    [func_blk_parent_class_INPUT]    }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_1_blk_class
{
    LABEL       [blk_class];
    HELP        [func_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    1,    [func_blk_class_AI]            }
    }
    HANDLING    READ;
}

func1_AI_1_blk_dd_reference                 LIKE VARIABLE    phys_blk_dd_reference
{
}

func1_AI_1_blk_dd_rev                       LIKE VARIABLE    phys_blk_dd_rev
{
}

func1_AI_1_blk_profile                      LIKE VARIABLE    phys_blk_profile
{
}

func1_AI_1_blk_profile_rev                  LIKE VARIABLE    phys_blk_profile_rev
{
}

func1_AI_1_blk_execution_time               LIKE VARIABLE    phys_blk_execution_time
{
}

func1_AI_1_blk_num_parameters               LIKE VARIABLE    phys_blk_num_parameters
{
}

func1_AI_1_blk_index_view_1                 LIKE VARIABLE    phys_blk_index_view_1
{
}

func1_AI_1_blk_num_view_lists               LIKE VARIABLE    phys_blk_num_view_lists
{
}

func1_AI_1_st_rev                           LIKE VARIABLE    phys_st_rev
{
}

func1_AI_1_tag_desc                         LIKE VARIABLE    phys_tag_desc
{
    REDEFINE LABEL        [MC_AI_1_tag_desc];
    TYPE                ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}

func1_AI_1_strategy                         LIKE VARIABLE    phys_strategy
{
}

func1_AI_1_alert_key                        LIKE VARIABLE    phys_alert_key
{
}

VARIABLE func1_AI_1_target_mode
{
    LABEL       [target_mode];
    HELP        [target_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0x08;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_actual_mode
{
    LABEL       [actual_mode];
    HELP        [actual_mode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0x08;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_1_permitted_mode
{
    LABEL       [permitted_mode];
    HELP        [permitted_mode_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE    0x98;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_1_normal_mode
{
    LABEL       [normal_mode];
    HELP        [normal_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0x08;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

func1_AI_1_current_state_alarm_sum          LIKE VARIABLE    phys_current_state_alarm_sum
{
    REDEFINE LABEL       [MC_alarm_sum];
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func1_AI_1_unacknowledged_state_alarm_sum   LIKE VARIABLE    phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func1_AI_1_unreported_state_alarm_sum       LIKE VARIABLE    phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func1_AI_1_disabled_state_alarm_sum         LIKE VARIABLE    phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func1_AI_1_batch_id
{
    LABEL       [func_batch_id];
    HELP        [func_batch_id_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_batch_unit
{
    LABEL       [func_batch_unit];
    HELP        [func_batch_unit_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_batch_operation
{
    LABEL       [func_batch_operation];
    HELP        [func_batch_operation_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_batch_phase
{
    LABEL       [func_batch_phase];
    HELP        [func_batch_phase_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    AI-1 : Additional Parameter                                      */
/*---------------------------------------------------------------------*/

VARIABLE func1_AI_1_out_value
{
    LABEL       [func_out_value];
    HELP        [func_ai_out_value_help];
    CLASS       OUTPUT&DYNAMIC;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING
        IF (func1_AI_1_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}

VARIABLE func1_AI_1_out_status_quality
{
    LABEL       [status_quality];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING
        IF (func1_AI_1_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}

func1_AI_1_out_status_limit                 LIKE VARIABLE    func1_AI_1_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func1_AI_1_pv_upper_range_value
{
    LABEL       [func_pv_scale_upper_value];
    HELP        [func_pv_scale_upper_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_pv_lower_range_value
{
    LABEL       [func_pv_scale_lower_value];
    HELP        [func_pv_scale_lower_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_out_upper_range_value
{
    LABEL       [func_out_scale_upper_value];
    HELP        [func_out_scale_upper_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_out_lower_range_value
{
    LABEL       [func_out_scale_lower_value];
    HELP        [func_out_scale_lower_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_out_unit
{
    LABEL       [digital_units];
    HELP        [digital_units_help];
    CLASS       CONTAINED & SERVICE;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE     1342;
        UNIT_LIST
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_out_decimal_point
{
    LABEL       [decimal_point];
    HELP        [decimal_point_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    2;
        {    0,   "0"        },
        {    1,   "1"        },
        {    2,   "2"        },
        {    3,   "3"        },
        {    4,   "4"        },
        {    5,   "5"        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_lin_type
{
    LABEL       [trans_lin_type];
    HELP        [trans_lin_type_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {     0, [linear]               },
        {    10, [lin_type_SQUARE_ROOT] }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_channel
{
    LABEL       [func_channel];
    HELP        [func_channel_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   1;
        {1,    "Mod_In_1(TB)"              },
        {2,    "Mod_In_2(TB)"              },
        {3,    "Mod_In_3(TB)"              },
        {4,    "Mod_In_4(TB)"              }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_pv_ftime
{
    LABEL       [func_pv_ftime];
    HELP        [func_pv_ftime_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
        DISPLAY_FORMAT ".1f";
    }
    CONSTANT_UNIT    [sec];
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_FSafeType
{
    LABEL     [func_failsafetype];
    HELP      [func_ai_fsafe_type];
    CLASS     CONTAINED;
    TYPE      ENUMERATED(1)
    {
        DEFAULT_VALUE    1;
        { 0,[func_ai_fsafe_type_FAIL_SAFE_VALUE]       },
        { 1,[func_ai_fsafe_type_STORING_LAST_SETPOINT] },
        { 2,[func_ai_fsafe_type_FAIL_SAFE_POSITION]    }
    }
    HANDLING  READ & WRITE;
}

VARIABLE func1_AI_1_FSafeValue
{
    LABEL     [func_failsafevalue];
    HELP      "";
    CLASS     CONTAINED;
    TYPE      FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING  READ & WRITE;
}

VARIABLE func1_AI_1_alarm_hys
{
    LABEL       [limit_hysteresis];
    HELP        [limit_hysteresis_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    CONSTANT_UNIT     [Percent];
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_hi_hi_lim
{
    LABEL       [limit_hi_hi];
    HELP        [limit_hi_hi_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_hi_lim
{
    LABEL       [limit_hi];
    HELP        [limit_hi_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_lo_lim
{
    LABEL       [limit_lo];
    HELP        [limit_lo_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_lo_lo_lim
{
    LABEL       [limit_lo_lo];
    HELP        [limit_lo_lo_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_hi_hi_alm_unacknowledged
{
    LABEL       [limit_alarm_unacknowledged];
    HELP        [limit_alarm_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_1_hi_hi_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_hi_hi_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_ALARM]    },
        {    1,    [limit_state_HI_HI]       }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_1_hi_hi_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_1_hi_hi_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_hi_hi_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_1_hi_hi_alm_value
{
    LABEL       [limit_alarm_value];
    HELP        [limit_hi_hi_alarm_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_1_hi_alm_unacknowledged
{
    LABEL       [limit_warn_unacknowledged];
    HELP        [limit_warn_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_1_hi_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_hi_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_WARNING]    },
        {    1,    [limit_state_HI]            }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_1_hi_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_1_hi_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_hi_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_1_hi_alm_value
{
    LABEL       [limit_warn_value];
    HELP        [limit_hi_warn_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_1_lo_alm_unacknowledged
{
    LABEL       [limit_warn_unacknowledged];
    HELP        [limit_warn_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_1_lo_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_lo_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_WARNING]    },
        {    1,    [limit_state_LO]            }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_1_lo_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_1_lo_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_lo_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_1_lo_alm_value
{
    LABEL       [limit_warn_value];
    HELP        [limit_lo_warn_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_1_lo_lo_alm_unacknowledged
{
    LABEL       [limit_alarm_unacknowledged];
    HELP        [limit_alarm_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_1_lo_lo_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_lo_lo_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_ALARM]        },
        {    1,    [limit_state_LO_LO]           }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_1_lo_lo_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_1_lo_lo_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_lo_lo_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_1_lo_lo_alm_value
{
    LABEL       [limit_alarm_value];
    HELP        [limit_lo_lo_alarm_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_1_simulate_status_quality
{
    LABEL       [status_quality];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    HANDLING    READ & WRITE;
}

func1_AI_1_simulate_status_limit            LIKE VARIABLE    func1_AI_1_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func1_AI_1_simulate_status_quality)
    }
}

VARIABLE func1_AI_1_simulate_value
{
    LABEL       [func_simulate_value];
    HELP        [func_ai_simulate_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_1_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_simulation_enabled
{
    LABEL       [func_simulation_enabled];
    HELP        [func_simulation_enabled_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [disabled]       },
        {    1,    [enabled]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_1_out_unit_text
{
    LABEL   [func_out_unit_text] ;
    HELP    [func_out_unit_text_help] ;
    CLASS   CONTAINED ;
    TYPE    ASCII(16) ;
    HANDLING READ & WRITE ;
}

/*---------------------------------------------------------------------*/
/*    AI-1 : Units                                                     */
/*---------------------------------------------------------------------*/

UNIT AI_1_OUT_SCALE_UNIT
{
    func1_AI_1_out_unit:

    func1_AI_1_out_value,
    func1_AI_1_out_upper_range_value,
    func1_AI_1_out_lower_range_value,
    func1_AI_1_hi_hi_lim,
    func1_AI_1_hi_lim,
    func1_AI_1_lo_lim,
    func1_AI_1_lo_lo_lim,
    func1_AI_1_hi_hi_alm_value,
    func1_AI_1_hi_alm_value,
    func1_AI_1_lo_alm_value,
    func1_AI_1_lo_lo_alm_value,
    func1_AI_1_FSafeValue
}

/***********************************************************************/
/*    AI-1 : COMMAND                                                   */
/***********************************************************************/

COMMAND read_func1_AI_1_blk
{
    BLOCK func1_AI_1;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_blk_reserve,
            func1_AI_1_blk_object,
            func1_AI_1_blk_parent_class,
            func1_AI_1_blk_class,
            func1_AI_1_blk_dd_reference,
            func1_AI_1_blk_dd_rev,
            func1_AI_1_blk_profile,
            func1_AI_1_blk_profile_rev,
            func1_AI_1_blk_execution_time,
            func1_AI_1_blk_num_parameters,
            func1_AI_1_blk_index_view_1,
            func1_AI_1_blk_num_view_lists
        }
    }
}

COMMAND read_func1_AI_1_st_rev
{
    BLOCK func1_AI_1;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_st_rev
        }
    }
}


COMMAND read_func1_AI_1_tag_desc
{
    BLOCK func1_AI_1;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_tag_desc
        }
    }
}

COMMAND write_func1_AI_1_tag_desc
{
    BLOCK func1_AI_1;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_tag_desc
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_strategy
{
    BLOCK func1_AI_1;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_strategy
        }
    }
}

COMMAND write_func1_AI_1_strategy
{
    BLOCK func1_AI_1;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_strategy
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_alert_key
{
    BLOCK func1_AI_1;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_alert_key
        }
    }
}

COMMAND write_func1_AI_1_alert_key
{
    BLOCK func1_AI_1;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_alert_key
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_target_mode
{
    BLOCK func1_AI_1;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_target_mode
        }
    }
}

COMMAND write_func1_AI_1_target_mode
{
    BLOCK func1_AI_1;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_target_mode
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_mode
{
    BLOCK func1_AI_1;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_actual_mode,
            func1_AI_1_permitted_mode,
            func1_AI_1_normal_mode
        }
    }
}

COMMAND read_func1_AI_1_alarm
{
    BLOCK func1_AI_1;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_current_state_alarm_sum,
            func1_AI_1_unacknowledged_state_alarm_sum,
            func1_AI_1_unreported_state_alarm_sum,
            func1_AI_1_disabled_state_alarm_sum
        }
    }
}

COMMAND read_func1_AI_1_batch_information
{
    BLOCK func1_AI_1;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_batch_id,
            func1_AI_1_batch_unit,
            func1_AI_1_batch_operation,
            func1_AI_1_batch_phase
        }
    }
}

COMMAND write_func1_AI_1_batch_information
{
    BLOCK func1_AI_1;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_batch_id,
            func1_AI_1_batch_unit,
            func1_AI_1_batch_operation,
            func1_AI_1_batch_phase
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_out
{
    BLOCK func1_AI_1;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_out_value,
            func1_AI_1_out_status_quality <0xFC>,
            func1_AI_1_out_status_limit   <0x03>
        }
    }
}

COMMAND write_func1_AI_1_out
{
    BLOCK func1_AI_1;
    INDEX 10;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_out_value,
            func1_AI_1_out_status_quality <0xFC>,
            func1_AI_1_out_status_limit   <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_pv
{
    BLOCK func1_AI_1;
    INDEX 11;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_pv_upper_range_value,
            func1_AI_1_pv_lower_range_value
        }
    }
}

COMMAND write_func1_AI_1_pv
{
    BLOCK func1_AI_1;
    INDEX 11;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_pv_upper_range_value,
            func1_AI_1_pv_lower_range_value
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_out_scale
{
    BLOCK func1_AI_1;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_out_upper_range_value,
            func1_AI_1_out_lower_range_value,
            func1_AI_1_out_unit,
            func1_AI_1_out_decimal_point
        }
    }
}

COMMAND write_func1_AI_1_out_scale
{
    BLOCK func1_AI_1;
    INDEX 12;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_out_upper_range_value,
            func1_AI_1_out_lower_range_value,
            func1_AI_1_out_unit,
            func1_AI_1_out_decimal_point
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_lin_type
{
    BLOCK func1_AI_1;
    INDEX 13;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_lin_type
        }
    }
}

COMMAND write_func1_AI_1_lin_type
{
    BLOCK func1_AI_1;
    INDEX 13;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_lin_type
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_channel
{
    BLOCK func1_AI_1;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_channel
        }
    }
}

COMMAND write_func1_AI_1_channel
{
    BLOCK func1_AI_1;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_channel
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_pv_ftime
{
    BLOCK func1_AI_1;
    INDEX 16;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_pv_ftime
        }
    }
}

COMMAND write_func1_AI_1_pv_ftime
{
    BLOCK func1_AI_1;
    INDEX 16;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_pv_ftime
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_FSafeType
{
    BLOCK func1_AI_1;
    INDEX 17;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_FSafeType
        }
    }
}

COMMAND write_func1_AI_1_FSafeType
{
    BLOCK func1_AI_1;
    INDEX 17;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_FSafeType
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_FSafeValue
{
    BLOCK func1_AI_1;
    INDEX 18;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_FSafeValue
        }
    }
}

COMMAND write_func1_AI_1_FSafeValue
{
    BLOCK func1_AI_1;
    INDEX 18;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_FSafeValue
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_alarm_hys
{
    BLOCK func1_AI_1;
    INDEX 19;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_alarm_hys
        }
    }
}


COMMAND write_func1_AI_1_alarm_hys
{
    BLOCK func1_AI_1;
    INDEX 19;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_alarm_hys
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_hi_hi_lim
{
    BLOCK func1_AI_1;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_hi_hi_lim
        }
    }
}

COMMAND write_func1_AI_1_hi_hi_lim
{
    BLOCK func1_AI_1;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_hi_hi_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_hi_lim
{
    BLOCK func1_AI_1;
    INDEX 23;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_hi_lim
        }
    }
}

COMMAND write_func1_AI_1_hi_lim
{
    BLOCK func1_AI_1;
    INDEX 23;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_hi_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_lo_lim
{
    BLOCK func1_AI_1;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_lo_lim
        }
    }
}

COMMAND write_func1_AI_1_lo_lim
{
    BLOCK func1_AI_1;
    INDEX 25;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_lo_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_lo_lo_lim
{
    BLOCK func1_AI_1;
    INDEX 27;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_lo_lo_lim
        }
    }
}

COMMAND write_func1_AI_1_lo_lo_lim
{
    BLOCK func1_AI_1;
    INDEX 27;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_lo_lo_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_1_hi_hi_alm
{
    BLOCK func1_AI_1;
    INDEX 30;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_hi_hi_alm_unacknowledged,
            func1_AI_1_hi_hi_alm_state,
            func1_AI_1_hi_hi_alm_time_stamp,
            func1_AI_1_hi_hi_alm_subcode,
            func1_AI_1_hi_hi_alm_value
        }
    }
}

COMMAND read_func1_AI_1_hi_alm
{
    BLOCK func1_AI_1;
    INDEX 31;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_hi_alm_unacknowledged,
            func1_AI_1_hi_alm_state,
            func1_AI_1_hi_alm_time_stamp,
            func1_AI_1_hi_alm_subcode,
            func1_AI_1_hi_alm_value
        }
    }
}

COMMAND read_func1_AI_1_lo_alm
{
    BLOCK func1_AI_1;
    INDEX 32;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_lo_alm_unacknowledged,
            func1_AI_1_lo_alm_state,
            func1_AI_1_lo_alm_time_stamp,
            func1_AI_1_lo_alm_subcode,
            func1_AI_1_lo_alm_value
        }
    }
}

COMMAND read_func1_AI_1_lo_lo_alm
{
    BLOCK func1_AI_1;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_lo_lo_alm_unacknowledged,
            func1_AI_1_lo_lo_alm_state,
            func1_AI_1_lo_lo_alm_time_stamp,
            func1_AI_1_lo_lo_alm_subcode,
            func1_AI_1_lo_lo_alm_value
        }
    }
}

COMMAND read_func1_AI_1_simulate
{
    BLOCK func1_AI_1;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_simulate_status_quality <0xFC>,
            func1_AI_1_simulate_status_limit   <0x03>,
            func1_AI_1_simulate_value,
            func1_AI_1_simulation_enabled
        }
    }
}

COMMAND write_func1_AI_1_simulate
{
    BLOCK func1_AI_1;
    INDEX 34;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_simulate_status_quality <0xFC>,
            func1_AI_1_simulate_status_limit   <0x03>,
            func1_AI_1_simulate_value,
            func1_AI_1_simulation_enabled
        }
        REPLY
        {
        }
    }
}


COMMAND read_func1_AI_1_out_unit_text
{
    BLOCK func1_AI_1;
    INDEX 35;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_1_out_unit_text
        }
    }
}

COMMAND write_func1_AI_1_out_unit_text
{
    BLOCK func1_AI_1;
    INDEX 35;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_1_out_unit_text
        }
        REPLY
        {
        }
    }
}

/***********************************************************************/
/*    AI-1 : MENUs                                                     */
/***********************************************************************/

/*---------------------------------------------------------------------*/
/*    AI-1 : (Table - Specialist)                                      */
/*---------------------------------------------------------------------*/

MENU Tab_s_AI_1
{
    LABEL        "AI-1";
    ITEMS
    {
        func1_AI_1_st_rev,
        Tab_s_AI_1_basic,
        Tab_s_AI_1_advanced
    }
}

MENU Tab_s_AI_1_basic
{
    LABEL        [MC_Tab_basic];
    ITEMS
    {
        Tab_s_AI_1_target_mode,
        Tab_s_AI_1_channel,
        Tab_s_func1_AI_1_pv_range,
        Tab_s_AI_1_outscale,
        Tab_s_AI_1_filter
    }
}

MENU Tab_s_AI_1_target_mode
{
    LABEL        [MC_Tab_mode_ai];
    ITEMS
    {
        func1_AI_1_target_mode
    }
}

MENU Tab_s_AI_1_channel
{
    LABEL        [MC_Tab_channel];
    ITEMS
    {
        func1_AI_1_channel
    }
}

MENU Tab_s_func1_AI_1_pv_range
{
    LABEL        [menu_input_measwindow];
    ITEMS
    {
        func1_AI_1_pv_lower_range_value,
        func1_AI_1_pv_upper_range_value
    }
}

MENU Tab_s_AI_1_outscale
{
    LABEL        [MC_Tab_outscale_ai];
    ITEMS
    {
        func1_AI_1_out_lower_range_value,
        func1_AI_1_out_upper_range_value,
        func1_AI_1_out_unit,
        func1_AI_1_out_decimal_point
    }
}

MENU Tab_s_AI_1_filter
{
    LABEL        [MC_Tab_filter_ai];
    ITEMS
    {
        func1_AI_1_pv_ftime
    }
}

MENU Tab_s_AI_1_advanced
{
    LABEL        [MC_Tab_advanced];
    ITEMS
    {
        Tab_s_func1_AI_1_limits,
        Tab_s_func1_AI_1_FSafe,
        Tab_s_func1_AI_1_batch
    }
}

MENU Tab_s_func1_AI_1_limits
{
    LABEL        [menu_output_limits];
    ITEMS
    {
        func1_AI_1_lo_lo_lim,
        func1_AI_1_lo_lim,
        func1_AI_1_hi_lim,
        func1_AI_1_hi_hi_lim,
        func1_AI_1_alarm_hys
    }
}

MENU Tab_s_func1_AI_1_FSafe
{
    LABEL        [menu_fail_safe];
    ITEMS
    {
        func1_AI_1_FSafeType,
        func1_AI_1_FSafeValue
    }
}

MENU Tab_s_func1_AI_1_batch
{
    LABEL        [menu_ident_batch_info];
    ITEMS
    {
        func1_AI_1_batch_id,
        func1_AI_1_batch_unit,
        func1_AI_1_batch_operation,
        func1_AI_1_batch_phase
    }
}

/*---------------------------------------------------------------------*/
/*    AI-1 : (Table - Maintenance)                                     */
/*---------------------------------------------------------------------*/

MENU Tab_m_AI_1
{
    LABEL        "AI-1";
    ITEMS
    {
        func1_AI_1_st_rev,
        Tab_m_AI_1_basic,
        Tab_m_AI_1_advanced
    }
}

MENU Tab_m_AI_1_basic
{
    LABEL        [MC_Tab_basic];
    ITEMS
    {
        Tab_m_AI_1_target_mode,
        Tab_m_AI_1_channel,
        Tab_m_func1_AI_1_pv_range,
        Tab_m_AI_1_outscale,
        Tab_m_AI_1_filter
    }
}

MENU Tab_m_AI_1_target_mode
{
    LABEL        [MC_Tab_mode_ai];
    ITEMS
    {
        func1_AI_1_target_mode    (READ_ONLY),
        func1_AI_1_actual_mode,
        func1_AI_1_permitted_mode,
        func1_AI_1_normal_mode
    }
}

MENU Tab_m_AI_1_channel
{
    LABEL        [MC_Tab_channel];
    ITEMS
    {
        func1_AI_1_channel        (READ_ONLY)
    }
}

MENU Tab_m_func1_AI_1_pv_range
{
    LABEL        [menu_input_measwindow];
    ITEMS
    {
        func1_AI_1_pv_lower_range_value   (READ_ONLY),
        func1_AI_1_pv_upper_range_value   (READ_ONLY)
    }
}

MENU Tab_m_AI_1_outscale
{
    LABEL        [MC_Tab_outscale_ai];
    ITEMS
    {
        func1_AI_1_out_lower_range_value  (READ_ONLY),
        func1_AI_1_out_upper_range_value  (READ_ONLY),
        func1_AI_1_out_unit               (READ_ONLY),
        func1_AI_1_out_decimal_point
    }
}

MENU Tab_m_AI_1_filter
{
    LABEL        [MC_Tab_filter_ai];
    ITEMS
    {
        func1_AI_1_pv_ftime           (READ_ONLY)
    }
}

MENU Tab_m_AI_1_advanced
{
    LABEL        [MC_Tab_advanced];
    ITEMS
    {
        Tab_m_func1_AI_1_limits,
        Tab_m_func1_AI_1_FSafe,
        Tab_m_func1_AI_1_batch
    }
}

MENU Tab_m_func1_AI_1_limits
{
    LABEL        [menu_output_limits];
    ITEMS
    {
        func1_AI_1_lo_lo_lim  (READ_ONLY),
        func1_AI_1_lo_lim     (READ_ONLY),
        func1_AI_1_hi_lim     (READ_ONLY),
        func1_AI_1_hi_hi_lim  (READ_ONLY),
        func1_AI_1_alarm_hys  (READ_ONLY)
    }
}

MENU Tab_m_func1_AI_1_FSafe
{
    LABEL        [menu_fail_safe];
    ITEMS
    {
        func1_AI_1_FSafeType  (READ_ONLY),
        func1_AI_1_FSafeValue (READ_ONLY)
    }
}

MENU Tab_m_func1_AI_1_batch
{
    LABEL        [menu_ident_batch_info];
    ITEMS
    {
        func1_AI_1_batch_id,
        func1_AI_1_batch_unit,
        func1_AI_1_batch_operation,
        func1_AI_1_batch_phase
    }
}

/*---------------------------------------------------------------------*/
/*    AI-1 : Online-Windows                                            */
/*---------------------------------------------------------------------*/

MENU Page_display_func1_AI_1
{
    LABEL        "AI-1";
    ITEMS
    {
        BarVal_display_func1_AI_1,
        Group_display_func1_AI_1_output,
        Group_display_func1_AI_1_input
    }
}

MENU BarVal_display_func1_AI_1
{
    LABEL        [MC_Output_Value];
    ITEMS
    {
        func1_AI_1_out_value                  (READ_ONLY),
        func1_AI_1_out_lower_range_value      (READ_ONLY),
        func1_AI_1_out_upper_range_value      (READ_ONLY)
    }
}

MENU Group_display_func1_AI_1_output
{
    LABEL        [MC_Output];
    ITEMS
    {
        func1_AI_1_actual_mode,
        COLUMNBREAK,
        func1_AI_1_out_status_quality         (READ_ONLY),
        func1_AI_1_out_status_limit           (READ_ONLY),
        func1_AI_1_current_state_alarm_sum
    }
}

MENU Group_display_func1_AI_1_input
{
    LABEL        [MC_Input];
    ITEMS
    {
        func1_AI_1_channel                (READ_ONLY),
        COLUMNBREAK,
        func1_AI_1_simulation_enabled     (READ_ONLY)
    }
}

MENU OnlineWindow_S_alarm_func1_AI_1
{
    LABEL        "AI-1";
    ITEMS
    {
        Page_overview_func1_AI_1,
        Page_alarm_sum_func1_AI_1,
        Page_upper_limit_alarm_func1_AI_1,
        Page_upper_limit_warning_func1_AI_1,
        Page_lower_limit_warning_func1_AI_1,
        Page_lower_limit_alarm_func1_AI_1
    }
}

MENU Page_overview_func1_AI_1
{
    LABEL        [menu_dialog_overview];
    ITEMS
    {
        func1_AI_1_hi_hi_lim          (READ_ONLY),
        func1_AI_1_hi_lim             (READ_ONLY),
        func1_AI_1_lo_lim             (READ_ONLY),
        func1_AI_1_lo_lo_lim          (READ_ONLY),
        COLUMNBREAK,
        func1_AI_1_hi_hi_alm_state    (NO_LABEL),
        func1_AI_1_hi_alm_state       (NO_LABEL),
        func1_AI_1_lo_alm_state       (NO_LABEL),
        func1_AI_1_lo_lo_alm_state    (NO_LABEL),
        COLUMNBREAK,
        func1_AI_1_hi_hi_alm_value    (NO_LABEL),
        func1_AI_1_hi_alm_value       (NO_LABEL),
        func1_AI_1_lo_alm_value       (NO_LABEL),
        func1_AI_1_lo_lo_alm_value    (NO_LABEL)
    }
}

MENU Page_alarm_sum_func1_AI_1
{
    LABEL        [menu_dialog_alarm_sum];
    ITEMS
    {
        func1_AI_1_current_state_alarm_sum,
        func1_AI_1_unacknowledged_state_alarm_sum,
        COLUMNBREAK,
        func1_AI_1_unreported_state_alarm_sum,
        func1_AI_1_disabled_state_alarm_sum
    }
}

MENU Page_upper_limit_alarm_func1_AI_1
{
    LABEL        [limit_hi_hi];
    ITEMS
    {
        func1_AI_1_hi_hi_alm_unacknowledged,
        func1_AI_1_hi_hi_alm_state,
        func1_AI_1_hi_hi_alm_subcode,
        func1_AI_1_hi_hi_lim          (READ_ONLY),
        func1_AI_1_hi_hi_alm_value
    }
}

MENU Page_upper_limit_warning_func1_AI_1
{
    LABEL        [limit_hi];
    ITEMS
    {
        func1_AI_1_hi_alm_unacknowledged,
        func1_AI_1_hi_alm_state,
        func1_AI_1_hi_alm_subcode,
        func1_AI_1_hi_lim          (READ_ONLY),
        func1_AI_1_hi_alm_value
    }
}

MENU Page_lower_limit_warning_func1_AI_1
{
    LABEL        [limit_lo];
    ITEMS
    {
        func1_AI_1_lo_alm_unacknowledged,
        func1_AI_1_lo_alm_state,
        func1_AI_1_lo_alm_subcode,
        func1_AI_1_lo_lim          (READ_ONLY),
        func1_AI_1_lo_alm_value
    }
}

MENU Page_lower_limit_alarm_func1_AI_1
{
    LABEL        [limit_lo_lo];
    ITEMS
    {
        func1_AI_1_lo_lo_alm_unacknowledged,
        func1_AI_1_lo_lo_alm_state,
        func1_AI_1_lo_lo_alm_subcode,
        func1_AI_1_lo_lo_lim          (READ_ONLY),
        func1_AI_1_lo_lo_alm_value
    }
}

MENU Page_diagnosis_func1_AI_1
{
    LABEL        "AI-1";
    ITEMS
    {
        func1_AI_1_blk_object,
        func1_AI_1_blk_parent_class,
        func1_AI_1_blk_class,
        func1_AI_1_blk_dd_reference,
        func1_AI_1_blk_dd_rev,
        func1_AI_1_blk_profile,
        func1_AI_1_blk_profile_rev,
        func1_AI_1_st_rev,
        func1_AI_1_actual_mode,
        func1_AI_1_simulation_enabled (READ_ONLY)
    }
}

/*---------------------------------------------------------------------*/
/*    AI-1 : Online-Dialogs                                            */
/*---------------------------------------------------------------------*/

MENU OnlineDialog_simulation_AI_1
{
	LABEL		"Simulate AI-1";
	ITEMS
	{
		Page_simulation_input_func1_AI_1,
		Page_simulation_output_func1_AI_1
	}
}

MENU Page_simulation_input_func1_AI_1
{
    LABEL        "AI1 Simulation (Measured Value)";
    ITEMS
    {
        func1_AI_1_simulation_enabled,
        Group_simulate_input_func1_AI_1
    }
}

MENU Group_simulate_input_func1_AI_1
{
    LABEL        [func_simulate_value];
    ITEMS
    {
        func1_AI_1_simulate_value,
        COLUMNBREAK,
        func1_AI_1_simulate_status_quality,
        func1_AI_1_simulate_status_limit
    }
}

MENU Page_simulation_output_func1_AI_1
{
    LABEL        "AI1 Simulation (Output)";
    ITEMS
    {
        func1_AI_1_target_mode,
        func1_AI_1_actual_mode,
        Group_simulate_output_func1_AI_1
    }
    POST_EDIT_ACTIONS
    {
        method_AI_1_target_mode
    }
}

MENU Group_simulate_output_func1_AI_1
{
    LABEL        [func_out_value];
    ITEMS
    {

        func1_AI_1_out_value,
        COLUMNBREAK,
        func1_AI_1_out_status_quality,
        func1_AI_1_out_status_limit
    }
}


MENU OnlineDialog_AI_1_setting
{
    LABEL "AI-1 Block Mode";
    ITEMS
    {
        Page_func1_AI_1_mode
    }
}

MENU Page_func1_AI_1_mode
{
    LABEL [MC_Config_Block_Mode];
    ITEMS
    {
        Group_AI_1_mode,
        Group_AI_1_out_value,
        func1_AI_1_current_state_alarm_sum,
        method_set
    }
    POST_EDIT_ACTIONS
    {
        method_AI_1_target_mode
    }
}

MENU Group_AI_1_mode
{
    LABEL [MC_Select_Block_Mode];
    ITEMS
    {
        func1_AI_1_target_mode,
        COLUMNBREAK,
        func1_AI_1_actual_mode
    }
    POST_EDIT_ACTIONS
    {
        method_AI_1_target_mode
    }
}

MENU Group_AI_1_out_value
{
    LABEL [MC_Output];
    ITEMS
    {
        func1_AI_1_out_value,
        COLUMNBREAK,
        func1_AI_1_out_status_quality,
        func1_AI_1_out_status_limit
    }
}

/*---------------------------------------------------------------------*/
/*    AI-1 : Offline-Windows                                           */
/*---------------------------------------------------------------------*/

MENU OfflineWindow_AI_1_geral
{
    LABEL "AI-1";
    ITEMS
    {
        Page_AI_1_Basic_Settings,
        Page_AI_1_Advanced_Settings,
        Page_AI_1_Batch_Info
    }
}

MENU Page_AI_1_Basic_Settings
{
    LABEL [MC_Tab_basic];
    ITEMS
    {
        Group_AI_1_Select_Input,
        Group_AI_1_Process_Value_Scale,
        Group_AI_1_Output_Scale_Unit,
        Group_AI_1_Set_filter_Time
    }
}

MENU Group_AI_1_Select_Input
{
    LABEL [MC_Tab_channel];
    ITEMS
    {
        func1_AI_1_channel,
        COLUMNBREAK,
        method_write_func1_AI_1_channel
    }
}

MENU Group_AI_1_Process_Value_Scale
{
    LABEL [MC_Process_Value_Scale];
    ITEMS
    {
        func1_AI_1_pv_lower_range_value,
        func1_AI_1_pv_upper_range_value,
        COLUMNBREAK,
        method_write_func1_AI_1_pv
    }
}

MENU Group_AI_1_Output_Scale_Unit
{
    LABEL [MC_Tab_outscale_ai];
    ITEMS
    {
        func1_AI_1_out_lower_range_value,
        func1_AI_1_out_upper_range_value,
        func1_AI_1_out_unit,
        func1_AI_1_out_decimal_point,
        COLUMNBREAK,
        method_write_func1_AI_1_out_scale
    }
}

MENU Group_AI_1_Set_filter_Time
{
    LABEL [MC_Tab_filter_ai];
    ITEMS
    {
        func1_AI_1_pv_ftime,
        COLUMNBREAK,
        method_write_func1_AI_1_pv_ftime
    }
}

MENU Page_AI_1_Advanced_Settings
{
    LABEL [MC_Tab_advanced];
    ITEMS
    {
        Group_AI_1_Set_Alarm_Warning_Limits,
        Group_AI_1_Set_Fail_Safe_Values
    }
}

MENU Group_AI_1_Set_Alarm_Warning_Limits
{
    LABEL [MC_Set_Alarm_Warning_Limits];
    ITEMS
    {
        func1_AI_1_lo_lo_lim,
        func1_AI_1_lo_lim,
        func1_AI_1_hi_lim,
        func1_AI_1_hi_hi_lim,
        func1_AI_1_alarm_hys,
        func1_AI_1_out_unit  (READ_ONLY)
        COLUMNBREAK,
        method_write_AI_1_Set_Alarm_Warning_Limits
    }
}

MENU Group_AI_1_Set_Fail_Safe_Values
{
    LABEL [MC_Set_Fail_Safe_Values];
    ITEMS
    {
        func1_AI_1_FSafeType,
        func1_AI_1_FSafeValue
        COLUMNBREAK,
        method_write_AI_1_Set_Fail_Safe_Values
    }
}

MENU Page_AI_1_Batch_Info
{
    LABEL [MC_Batch_Info];
    ITEMS
    {
        Group_AI_1_Define_Batch_Information
    }
}

MENU Group_AI_1_Define_Batch_Information
{
    LABEL [MC_Define_Batch_Info];
    ITEMS
    {
        func1_AI_1_batch_id,
        func1_AI_1_batch_unit,
        func1_AI_1_batch_operation,
        func1_AI_1_batch_phase
        COLUMNBREAK,
        method_write_func1_AI_1_batch_information
    }
}


/*---------------------------------------------------------------------*/
/*    AI-1 : Methods                                                   */
/*---------------------------------------------------------------------*/

METHOD method_AI_1_target_mode
{
    LABEL [MC_method_target_mode];
    DEFINITION
    {
        WriteCommand (write_func1_AI_1_target_mode);
    }
}

METHOD method_write_func1_AI_1_channel
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_1_channel);
        ReadCommand(read_func1_AI_1_channel);
    }
}

METHOD method_write_func1_AI_1_pv
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_1_pv);
        ReadCommand(read_func1_AI_1_pv);
    }
}

METHOD method_write_func1_AI_1_out_scale
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_1_out_scale);
        ReadCommand(read_func1_AI_1_out_scale);
    }
}

METHOD method_write_func1_AI_1_pv_ftime
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_1_pv_ftime);
        ReadCommand(read_func1_AI_1_pv_ftime);
    }
}

METHOD method_write_AI_1_Set_Alarm_Warning_Limits
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_1_lo_lo_lim);
        WriteCommand(write_func1_AI_1_lo_lim);
        WriteCommand(write_func1_AI_1_hi_lim);
        WriteCommand(write_func1_AI_1_hi_hi_lim);
        WriteCommand(write_func1_AI_1_alarm_hys);
        ReadCommand(read_func1_AI_1_lo_lo_lim);
        ReadCommand(read_func1_AI_1_lo_lim);
        ReadCommand(read_func1_AI_1_hi_lim);
        ReadCommand(read_func1_AI_1_hi_hi_lim);
        ReadCommand(read_func1_AI_1_alarm_hys);
    }
}

METHOD method_write_AI_1_Set_Fail_Safe_Values
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_1_FSafeType);
        WriteCommand(write_func1_AI_1_FSafeValue);
        ReadCommand(read_func1_AI_1_FSafeType);
        ReadCommand(read_func1_AI_1_FSafeValue);
    }
}

METHOD method_write_func1_AI_1_batch_information
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_1_batch_information);
        ReadCommand(read_func1_AI_1_batch_information);
    }
}

/***********************************************************************/
/*    AI Function Block 2                                              */
/***********************************************************************/

BLOCK func1_AI_2
{
    TYPE    FUNCTION;
    NUMBER  2;
}

func1_AI_2_blk_reserve                      LIKE VARIABLE    phys_blk_reserve
{
}

VARIABLE func1_AI_2_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [blk_block_object_FUNCTION]        }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_2_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [func_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    1,    [func_blk_parent_class_INPUT]    }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_2_blk_class
{
    LABEL       [blk_class];
    HELP        [func_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    1,    [func_blk_class_AI]            }
    }
    HANDLING    READ;
}

func1_AI_2_blk_dd_reference                 LIKE VARIABLE    phys_blk_dd_reference
{
}

func1_AI_2_blk_dd_rev                       LIKE VARIABLE    phys_blk_dd_rev
{
}

func1_AI_2_blk_profile                      LIKE VARIABLE    phys_blk_profile
{
}

func1_AI_2_blk_profile_rev                  LIKE VARIABLE    phys_blk_profile_rev
{
}

func1_AI_2_blk_execution_time               LIKE VARIABLE    phys_blk_execution_time
{
}

func1_AI_2_blk_num_parameters               LIKE VARIABLE    phys_blk_num_parameters
{
}

func1_AI_2_blk_index_view_1                 LIKE VARIABLE    phys_blk_index_view_1
{
}

func1_AI_2_blk_num_view_lists               LIKE VARIABLE    phys_blk_num_view_lists
{
}

func1_AI_2_st_rev                           LIKE VARIABLE    phys_st_rev
{
}

func1_AI_2_tag_desc                         LIKE VARIABLE    phys_tag_desc
{
    REDEFINE LABEL        [MC_AI_2_tag_desc];
    TYPE                ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}

func1_AI_2_strategy                         LIKE VARIABLE    phys_strategy
{
}

func1_AI_2_alert_key                        LIKE VARIABLE    phys_alert_key
{
}

VARIABLE func1_AI_2_target_mode
{
    LABEL       [target_mode];
    HELP        [target_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0x08;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_actual_mode
{
    LABEL       [actual_mode];
    HELP        [actual_mode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0x08;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_2_permitted_mode
{
    LABEL       [permitted_mode];
    HELP        [permitted_mode_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE    0x98;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_2_normal_mode
{
    LABEL       [normal_mode];
    HELP        [normal_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0x08;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

func1_AI_2_current_state_alarm_sum          LIKE VARIABLE    phys_current_state_alarm_sum
{
    REDEFINE LABEL      [MC_alarm_sum];
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func1_AI_2_unacknowledged_state_alarm_sum   LIKE VARIABLE    phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func1_AI_2_unreported_state_alarm_sum       LIKE VARIABLE    phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func1_AI_2_disabled_state_alarm_sum         LIKE VARIABLE    phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func1_AI_2_batch_id
{
    LABEL       [func_batch_id];
    HELP        [func_batch_id_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_batch_unit
{
    LABEL       [func_batch_unit];
    HELP        [func_batch_unit_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_batch_operation
{
    LABEL       [func_batch_operation];
    HELP        [func_batch_operation_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_batch_phase
{
    LABEL       [func_batch_phase];
    HELP        [func_batch_phase_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    AI-2 : Additional Parameter                                      */
/*---------------------------------------------------------------------*/

VARIABLE func1_AI_2_out_value
{
    LABEL       [func_out_value];
    HELP        [func_ai_out_value_help];
    CLASS       OUTPUT&DYNAMIC;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING
        IF (func1_AI_2_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}

VARIABLE func1_AI_2_out_status_quality
{
    LABEL       [status_quality];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING
        IF (func1_AI_2_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}

func1_AI_2_out_status_limit                 LIKE VARIABLE    func1_AI_2_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func1_AI_2_pv_upper_range_value
{
    LABEL       [func_pv_scale_upper_value];
    HELP        [func_pv_scale_upper_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_pv_lower_range_value
{
    LABEL       [func_pv_scale_lower_value];
    HELP        [func_pv_scale_lower_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_out_upper_range_value
{
    LABEL       [func_out_scale_upper_value];
    HELP        [func_out_scale_upper_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_out_lower_range_value
{
    LABEL       [func_out_scale_lower_value];
    HELP        [func_out_scale_lower_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_out_unit
{
    LABEL       [digital_units];
    HELP        [digital_units_help];
    CLASS       CONTAINED & SERVICE;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE  1342;
        UNIT_LIST
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_out_decimal_point
{
    LABEL       [decimal_point];
    HELP        [decimal_point_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    2;
        {    0,   "0"        },
        {    1,   "1"        },
        {    2,   "2"        },
        {    3,   "3"        },
        {    4,   "4"        },
        {    5,   "5"        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_lin_type
{
    LABEL       [trans_lin_type];
    HELP        [trans_lin_type_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {     0, [linear]               },
        {    10, [lin_type_SQUARE_ROOT] }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_channel
{
    LABEL       [func_channel];
    HELP        [func_channel_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   2;
        {1,    "Mod_In_1(TB)"              },
        {2,    "Mod_In_2(TB)"              },
        {3,    "Mod_In_3(TB)"              },
        {4,    "Mod_In_4(TB)"              }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_pv_ftime
{
    LABEL       [func_pv_ftime];
    HELP        [func_pv_ftime_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
        DISPLAY_FORMAT ".1f";
    }
    CONSTANT_UNIT    [sec];
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_FSafeType
{
    LABEL     [func_failsafetype];
    HELP      [func_ai_fsafe_type];
    CLASS     CONTAINED;
    TYPE      ENUMERATED(1)
    {
        DEFAULT_VALUE    1;
        { 0,[func_ai_fsafe_type_FAIL_SAFE_VALUE]       },
        { 1,[func_ai_fsafe_type_STORING_LAST_SETPOINT] },
        { 2,[func_ai_fsafe_type_FAIL_SAFE_POSITION]    }
    }
    HANDLING  READ & WRITE;
}

VARIABLE func1_AI_2_FSafeValue
{
    LABEL     [func_failsafevalue];
    /*
    HELP      [];
    */
    CLASS     CONTAINED;
    TYPE      FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING  READ & WRITE;
}

VARIABLE func1_AI_2_alarm_hys
{
    LABEL       [limit_hysteresis];
    HELP        [limit_hysteresis_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    CONSTANT_UNIT     [Percent];
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_hi_hi_lim
{
    LABEL       [limit_hi_hi];
    HELP        [limit_hi_hi_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_hi_lim
{
    LABEL       [limit_hi];
    HELP        [limit_hi_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_lo_lim
{
    LABEL       [limit_lo];
    HELP        [limit_lo_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_lo_lo_lim
{
    LABEL       [limit_lo_lo];
    HELP        [limit_lo_lo_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_hi_hi_alm_unacknowledged
{
    LABEL       [limit_alarm_unacknowledged];
    HELP        [limit_alarm_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_2_hi_hi_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_hi_hi_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_ALARM]    },
        {    1,    [limit_state_HI_HI]       }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_2_hi_hi_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_2_hi_hi_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_hi_hi_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_2_hi_hi_alm_value
{
    LABEL       [limit_alarm_value];
    HELP        [limit_hi_hi_alarm_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_2_hi_alm_unacknowledged
{
    LABEL       [limit_warn_unacknowledged];
    HELP        [limit_warn_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_2_hi_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_hi_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_WARNING]    },
        {    1,    [limit_state_HI]            }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_2_hi_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_2_hi_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_hi_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_2_hi_alm_value
{
    LABEL       [limit_warn_value];
    HELP        [limit_hi_warn_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_2_lo_alm_unacknowledged
{
    LABEL       [limit_warn_unacknowledged];
    HELP        [limit_warn_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_2_lo_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_lo_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_WARNING]    },
        {    1,    [limit_state_LO]            }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_2_lo_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_2_lo_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_lo_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_2_lo_alm_value
{
    LABEL       [limit_warn_value];
    HELP        [limit_lo_warn_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_2_lo_lo_alm_unacknowledged
{
    LABEL       [limit_alarm_unacknowledged];
    HELP        [limit_alarm_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_2_lo_lo_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_lo_lo_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_ALARM]        },
        {    1,    [limit_state_LO_LO]           }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_2_lo_lo_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_2_lo_lo_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_lo_lo_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_2_lo_lo_alm_value
{
    LABEL       [limit_alarm_value];
    HELP        [limit_lo_lo_alarm_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_2_simulate_status_quality
{
    LABEL       [status_quality];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    HANDLING    READ & WRITE;
}

func1_AI_2_simulate_status_limit            LIKE VARIABLE    func1_AI_2_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func1_AI_2_simulate_status_quality)
    }
}

VARIABLE func1_AI_2_simulate_value
{
    LABEL       [func_simulate_value];
    HELP        [func_ai_simulate_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_2_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_simulation_enabled
{
    LABEL       [func_simulation_enabled];
    HELP        [func_simulation_enabled_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [disabled]       },
        {    1,    [enabled]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_2_out_unit_text
{
    LABEL   [func_out_unit_text] ;
    HELP    [func_out_unit_text_help] ;
    CLASS   CONTAINED ;
    TYPE    ASCII(16) ;
    HANDLING READ & WRITE ;
}

/*---------------------------------------------------------------------*/
/*    AI-2 : Units                                                     */
/*---------------------------------------------------------------------*/

UNIT AI_2_OUT_SCALE_UNIT
{
    func1_AI_2_out_unit:

    func1_AI_2_out_value,
    func1_AI_2_out_upper_range_value,
    func1_AI_2_out_lower_range_value,
    func1_AI_2_hi_hi_lim,
    func1_AI_2_hi_lim,
    func1_AI_2_lo_lim,
    func1_AI_2_lo_lo_lim,
    func1_AI_2_hi_hi_alm_value,
    func1_AI_2_hi_alm_value,
    func1_AI_2_lo_alm_value,
    func1_AI_2_lo_lo_alm_value,
    func1_AI_2_FSafeValue
}

/***********************************************************************/
/*    AI-2 : COMMAND                                                   */
/***********************************************************************/

COMMAND read_func1_AI_2_blk
{
    BLOCK func1_AI_2;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_blk_reserve,
            func1_AI_2_blk_object,
            func1_AI_2_blk_parent_class,
            func1_AI_2_blk_class,
            func1_AI_2_blk_dd_reference,
            func1_AI_2_blk_dd_rev,
            func1_AI_2_blk_profile,
            func1_AI_2_blk_profile_rev,
            func1_AI_2_blk_execution_time,
            func1_AI_2_blk_num_parameters,
            func1_AI_2_blk_index_view_1,
            func1_AI_2_blk_num_view_lists
        }
    }
}

COMMAND read_func1_AI_2_st_rev
{
    BLOCK func1_AI_2;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_st_rev
        }
    }
}


COMMAND read_func1_AI_2_tag_desc
{
    BLOCK func1_AI_2;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_tag_desc
        }
    }
}

COMMAND write_func1_AI_2_tag_desc
{
    BLOCK func1_AI_2;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_tag_desc
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_strategy
{
    BLOCK func1_AI_2;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_strategy
        }
    }
}

COMMAND write_func1_AI_2_strategy
{
    BLOCK func1_AI_2;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_strategy
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_alert_key
{
    BLOCK func1_AI_2;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_alert_key
        }
    }
}

COMMAND write_func1_AI_2_alert_key
{
    BLOCK func1_AI_2;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_alert_key
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_target_mode
{
    BLOCK func1_AI_2;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_target_mode
        }
    }
}

COMMAND write_func1_AI_2_target_mode
{
    BLOCK func1_AI_2;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_target_mode
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_mode
{
    BLOCK func1_AI_2;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_actual_mode,
            func1_AI_2_permitted_mode,
            func1_AI_2_normal_mode
        }
    }
}

COMMAND read_func1_AI_2_alarm
{
    BLOCK func1_AI_2;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_current_state_alarm_sum,
            func1_AI_2_unacknowledged_state_alarm_sum,
            func1_AI_2_unreported_state_alarm_sum,
            func1_AI_2_disabled_state_alarm_sum
        }
    }
}

COMMAND read_func1_AI_2_batch_information
{
    BLOCK func1_AI_2;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_batch_id,
            func1_AI_2_batch_unit,
            func1_AI_2_batch_operation,
            func1_AI_2_batch_phase
        }
    }
}

COMMAND write_func1_AI_2_batch_information
{
    BLOCK func1_AI_2;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_batch_id,
            func1_AI_2_batch_unit,
            func1_AI_2_batch_operation,
            func1_AI_2_batch_phase
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_out
{
    BLOCK func1_AI_2;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_out_value,
            func1_AI_2_out_status_quality <0xFC>,
            func1_AI_2_out_status_limit   <0x03>
        }
    }
}

COMMAND write_func1_AI_2_out
{
    BLOCK func1_AI_2;
    INDEX 10;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_out_value,
            func1_AI_2_out_status_quality <0xFC>,
            func1_AI_2_out_status_limit   <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_pv
{
    BLOCK func1_AI_2;
    INDEX 11;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_pv_upper_range_value,
            func1_AI_2_pv_lower_range_value
        }
    }
}

COMMAND write_func1_AI_2_pv
{
    BLOCK func1_AI_2;
    INDEX 11;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_pv_upper_range_value,
            func1_AI_2_pv_lower_range_value
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_out_scale
{
    BLOCK func1_AI_2;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_out_upper_range_value,
            func1_AI_2_out_lower_range_value,
            func1_AI_2_out_unit,
            func1_AI_2_out_decimal_point
        }
    }
}

COMMAND write_func1_AI_2_out_scale
{
    BLOCK func1_AI_2;
    INDEX 12;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_out_upper_range_value,
            func1_AI_2_out_lower_range_value,
            func1_AI_2_out_unit,
            func1_AI_2_out_decimal_point
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_lin_type
{
    BLOCK func1_AI_2;
    INDEX 13;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_lin_type
        }
    }
}

COMMAND write_func1_AI_2_lin_type
{
    BLOCK func1_AI_2;
    INDEX 13;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_lin_type
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_channel
{
    BLOCK func1_AI_2;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_channel
        }
    }
}

COMMAND write_func1_AI_2_channel
{
    BLOCK func1_AI_2;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_channel
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_pv_ftime
{
    BLOCK func1_AI_2;
    INDEX 16;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_pv_ftime
        }
    }
}

COMMAND write_func1_AI_2_pv_ftime
{
    BLOCK func1_AI_2;
    INDEX 16;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_pv_ftime
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_FSafeType
{
    BLOCK func1_AI_2;
    INDEX 17;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_FSafeType
        }
    }
}

COMMAND write_func1_AI_2_FSafeType
{
    BLOCK func1_AI_2;
    INDEX 17;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_FSafeType
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_FSafeValue
{
    BLOCK func1_AI_2;
    INDEX 18;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_FSafeValue
        }
    }
}

COMMAND write_func1_AI_2_FSafeValue
{
    BLOCK func1_AI_2;
    INDEX 18;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_FSafeValue
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_alarm_hys
{
    BLOCK func1_AI_2;
    INDEX 19;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_alarm_hys
        }
    }
}


COMMAND write_func1_AI_2_alarm_hys
{
    BLOCK func1_AI_2;
    INDEX 19;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_alarm_hys
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_hi_hi_lim
{
    BLOCK func1_AI_2;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_hi_hi_lim
        }
    }
}

COMMAND write_func1_AI_2_hi_hi_lim
{
    BLOCK func1_AI_2;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_hi_hi_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_hi_lim
{
    BLOCK func1_AI_2;
    INDEX 23;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_hi_lim
        }
    }
}

COMMAND write_func1_AI_2_hi_lim
{
    BLOCK func1_AI_2;
    INDEX 23;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_hi_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_lo_lim
{
    BLOCK func1_AI_2;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_lo_lim
        }
    }
}

COMMAND write_func1_AI_2_lo_lim
{
    BLOCK func1_AI_2;
    INDEX 25;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_lo_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_lo_lo_lim
{
    BLOCK func1_AI_2;
    INDEX 27;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_lo_lo_lim
        }
    }
}

COMMAND write_func1_AI_2_lo_lo_lim
{
    BLOCK func1_AI_2;
    INDEX 27;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_lo_lo_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_2_hi_hi_alm
{
    BLOCK func1_AI_2;
    INDEX 30;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_hi_hi_alm_unacknowledged,
            func1_AI_2_hi_hi_alm_state,
            func1_AI_2_hi_hi_alm_time_stamp,
            func1_AI_2_hi_hi_alm_subcode,
            func1_AI_2_hi_hi_alm_value
        }
    }
}

COMMAND read_func1_AI_2_hi_alm
{
    BLOCK func1_AI_2;
    INDEX 31;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_hi_alm_unacknowledged,
            func1_AI_2_hi_alm_state,
            func1_AI_2_hi_alm_time_stamp,
            func1_AI_2_hi_alm_subcode,
            func1_AI_2_hi_alm_value
        }
    }
}

COMMAND read_func1_AI_2_lo_alm
{
    BLOCK func1_AI_2;
    INDEX 32;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_lo_alm_unacknowledged,
            func1_AI_2_lo_alm_state,
            func1_AI_2_lo_alm_time_stamp,
            func1_AI_2_lo_alm_subcode,
            func1_AI_2_lo_alm_value
        }
    }
}

COMMAND read_func1_AI_2_lo_lo_alm
{
    BLOCK func1_AI_2;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_lo_lo_alm_unacknowledged,
            func1_AI_2_lo_lo_alm_state,
            func1_AI_2_lo_lo_alm_time_stamp,
            func1_AI_2_lo_lo_alm_subcode,
            func1_AI_2_lo_lo_alm_value
        }
    }
}

COMMAND read_func1_AI_2_simulate
{
    BLOCK func1_AI_2;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_simulate_status_quality <0xFC>,
            func1_AI_2_simulate_status_limit <0x03>,
            func1_AI_2_simulate_value,
            func1_AI_2_simulation_enabled
        }
    }
}

COMMAND write_func1_AI_2_simulate
{
    BLOCK func1_AI_2;
    INDEX 34;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_simulate_status_quality <0xFC>,
            func1_AI_2_simulate_status_limit   <0x03>,
            func1_AI_2_simulate_value,
            func1_AI_2_simulation_enabled
        }
        REPLY
        {
        }
    }
}


COMMAND read_func1_AI_2_out_unit_text
{
    BLOCK func1_AI_2;
    INDEX 35;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_2_out_unit_text
        }
    }
}

COMMAND write_func1_AI_2_out_unit_text
{
    BLOCK func1_AI_2;
    INDEX 35;
    OPERATION WRITE ;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_2_out_unit_text
        }
        REPLY
        {
        }
    }
}

/***********************************************************************/
/*    AI-2 : MENUs                                                     */
/***********************************************************************/

/*---------------------------------------------------------------------*/
/*    AI-2 : (Table - Specialist)                                      */
/*---------------------------------------------------------------------*/

MENU Tab_s_AI_2
{
    LABEL        "AI-2";
    ITEMS
    {
        func1_AI_2_st_rev
        Tab_s_AI_2_basic,
        Tab_s_AI_2_advanced
    }
}

MENU Tab_s_AI_2_basic
{
    LABEL        [MC_Tab_basic];
    ITEMS
    {
        Tab_s_AI_2_target_mode,
        Tab_s_AI_2_channel,
        Tab_s_func1_AI_2_pv_range,
        Tab_s_AI_2_outscale,
        Tab_s_AI_2_filter
    }
}

MENU Tab_s_AI_2_target_mode
{
    LABEL        [MC_Tab_mode_ai];
    ITEMS
    {
        func1_AI_2_target_mode
    }
}

MENU Tab_s_AI_2_channel
{
    LABEL        [MC_Tab_channel];
    ITEMS
    {
        func1_AI_2_channel
    }
}

MENU Tab_s_func1_AI_2_pv_range
{
    LABEL        [menu_input_measwindow];
    ITEMS
    {
        func1_AI_2_pv_lower_range_value,
        func1_AI_2_pv_upper_range_value
    }
}

MENU Tab_s_AI_2_outscale
{
    LABEL        [MC_Tab_outscale_ai];
    ITEMS
    {
        func1_AI_2_out_lower_range_value,
        func1_AI_2_out_upper_range_value,
        func1_AI_2_out_unit,
        func1_AI_2_out_decimal_point
    }
}

MENU Tab_s_AI_2_filter
{
    LABEL        [MC_Tab_filter_ai];
    ITEMS
    {
        func1_AI_2_pv_ftime
    }
}

MENU Tab_s_AI_2_advanced
{
    LABEL        [MC_Tab_advanced];
    ITEMS
    {
        Tab_s_func1_AI_2_limits,
        Tab_s_func1_AI_2_FSafe,
        Tab_s_func1_AI_2_batch
    }
}

MENU Tab_s_func1_AI_2_limits
{
    LABEL        [menu_output_limits];
    ITEMS
    {
        func1_AI_2_lo_lo_lim,
        func1_AI_2_lo_lim,
        func1_AI_2_hi_lim,
        func1_AI_2_hi_hi_lim,
        func1_AI_2_alarm_hys
    }
}

MENU Tab_s_func1_AI_2_FSafe
{
    LABEL        [menu_fail_safe];
    ITEMS
    {
        func1_AI_2_FSafeType,
        func1_AI_2_FSafeValue
    }
}

MENU Tab_s_func1_AI_2_batch
{
    LABEL        [menu_ident_batch_info];
    ITEMS
    {
        func1_AI_2_batch_id,
        func1_AI_2_batch_unit,
        func1_AI_2_batch_operation,
        func1_AI_2_batch_phase
    }
}

/*---------------------------------------------------------------------*/
/*    AI-2 : (Table - Maintenance)                                     */
/*---------------------------------------------------------------------*/

MENU Tab_m_AI_2
{
    LABEL        "AI-2";
    ITEMS
    {
        func1_AI_2_st_rev,
        Tab_m_AI_2_basic,
        Tab_m_AI_2_advanced
    }
}

MENU Tab_m_AI_2_basic
{
    LABEL        [MC_Tab_basic];
    ITEMS
    {
        Tab_m_AI_2_target_mode,
        Tab_m_AI_2_channel,
        Tab_m_func1_AI_2_pv_range,
        Tab_m_AI_2_outscale,
        Tab_m_AI_2_filter
    }
}

MENU Tab_m_AI_2_target_mode
{
    LABEL        [MC_Tab_mode_ai];
    ITEMS
    {
        func1_AI_2_target_mode    (READ_ONLY),
        func1_AI_2_actual_mode,
        func1_AI_2_permitted_mode,
        func1_AI_2_normal_mode
    }
}

MENU Tab_m_AI_2_channel
{
    LABEL        [MC_Tab_channel];
    ITEMS
    {
        func1_AI_2_channel        (READ_ONLY)
    }
}

MENU Tab_m_func1_AI_2_pv_range
{
    LABEL        [menu_input_measwindow];
    ITEMS
    {
        func1_AI_2_pv_lower_range_value   (READ_ONLY),
        func1_AI_2_pv_upper_range_value   (READ_ONLY)
    }
}

MENU Tab_m_AI_2_outscale
{
    LABEL        [MC_Tab_outscale_ai];
    ITEMS
    {
        func1_AI_2_out_lower_range_value  (READ_ONLY),
        func1_AI_2_out_upper_range_value  (READ_ONLY),
        func1_AI_2_out_unit               (READ_ONLY),
        func1_AI_2_out_decimal_point
    }
}

MENU Tab_m_AI_2_filter
{
    LABEL        [MC_Tab_filter_ai];
    ITEMS
    {
        func1_AI_2_pv_ftime           (READ_ONLY)
    }
}

MENU Tab_m_AI_2_advanced
{
    LABEL        [MC_Tab_advanced];
    ITEMS
    {
        Tab_m_func1_AI_2_limits,
        Tab_m_func1_AI_2_FSafe,
        Tab_m_func1_AI_2_batch
    }
}

MENU Tab_m_func1_AI_2_limits
{
    LABEL        [menu_output_limits];
    ITEMS
    {
        func1_AI_2_lo_lo_lim  (READ_ONLY),
        func1_AI_2_lo_lim     (READ_ONLY),
        func1_AI_2_hi_lim     (READ_ONLY),
        func1_AI_2_hi_hi_lim  (READ_ONLY),
        func1_AI_2_alarm_hys  (READ_ONLY)
    }
}

MENU Tab_m_func1_AI_2_FSafe
{
    LABEL        [menu_fail_safe];
    ITEMS
    {
        func1_AI_2_FSafeType  (READ_ONLY),
        func1_AI_2_FSafeValue (READ_ONLY)
    }
}

MENU Tab_m_func1_AI_2_batch
{
    LABEL        [menu_ident_batch_info];
    ITEMS
    {
        func1_AI_2_batch_id,
        func1_AI_2_batch_unit,
        func1_AI_2_batch_operation,
        func1_AI_2_batch_phase
    }
}

/*---------------------------------------------------------------------*/
/*    AI-2 : Online-Windows                                            */
/*---------------------------------------------------------------------*/

MENU Page_display_func1_AI_2
{
    LABEL        "AI-2";
    ITEMS
    {
        BarVal_display_func1_AI_2,
        Group_display_func1_AI_2_output,
        Group_display_func1_AI_2_input
    }
}

MENU BarVal_display_func1_AI_2
{
    LABEL        [MC_Output_Value];
    ITEMS
    {
        func1_AI_2_out_value                  (READ_ONLY),
        func1_AI_2_out_lower_range_value      (READ_ONLY),
        func1_AI_2_out_upper_range_value      (READ_ONLY)
    }
}

MENU Group_display_func1_AI_2_output
{
    LABEL        [MC_Output];
    ITEMS
    {
        func1_AI_2_actual_mode,
        COLUMNBREAK,
        func1_AI_2_out_status_quality         (READ_ONLY),
        func1_AI_2_out_status_limit           (READ_ONLY),
        func1_AI_2_current_state_alarm_sum
    }
}

MENU Group_display_func1_AI_2_input
{
    LABEL        [MC_Input];
    ITEMS
    {
        func1_AI_2_channel                (READ_ONLY),
        COLUMNBREAK,
        func1_AI_2_simulation_enabled     (READ_ONLY)
    }
}

MENU OnlineWindow_S_alarm_func1_AI_2
{
    LABEL        "AI-2";
    ITEMS
    {
        Page_overview_func1_AI_2,
        Page_alarm_sum_func1_AI_2,
        Page_upper_limit_alarm_func1_AI_2,
        Page_upper_limit_warning_func1_AI_2,
        Page_lower_limit_warning_func1_AI_2,
        Page_lower_limit_alarm_func1_AI_2
    }
}

MENU Page_overview_func1_AI_2
{
    LABEL        [menu_dialog_overview];
    ITEMS
    {
        func1_AI_2_hi_hi_lim          (READ_ONLY),
        func1_AI_2_hi_lim             (READ_ONLY),
        func1_AI_2_lo_lim             (READ_ONLY),
        func1_AI_2_lo_lo_lim          (READ_ONLY),
        COLUMNBREAK,
        func1_AI_2_hi_hi_alm_state    (NO_LABEL),
        func1_AI_2_hi_alm_state       (NO_LABEL),
        func1_AI_2_lo_alm_state       (NO_LABEL),
        func1_AI_2_lo_lo_alm_state    (NO_LABEL),
        COLUMNBREAK,
        func1_AI_2_hi_hi_alm_value    (NO_LABEL),
        func1_AI_2_hi_alm_value       (NO_LABEL),
        func1_AI_2_lo_alm_value       (NO_LABEL),
        func1_AI_2_lo_lo_alm_value    (NO_LABEL)
    }
}

MENU Page_alarm_sum_func1_AI_2
{
    LABEL        [menu_dialog_alarm_sum];
    ITEMS
    {
        func1_AI_2_current_state_alarm_sum,
        func1_AI_2_unacknowledged_state_alarm_sum,
        COLUMNBREAK,
        func1_AI_2_unreported_state_alarm_sum,
        func1_AI_2_disabled_state_alarm_sum
    }
}

MENU Page_upper_limit_alarm_func1_AI_2
{
    LABEL        [limit_hi_hi];
    ITEMS
    {
        func1_AI_2_hi_hi_alm_unacknowledged,
        func1_AI_2_hi_hi_alm_state,
        func1_AI_2_hi_hi_alm_subcode,
        func1_AI_2_hi_hi_lim          (READ_ONLY),
        func1_AI_2_hi_hi_alm_value
    }
}

MENU Page_upper_limit_warning_func1_AI_2
{
    LABEL        [limit_hi];
    ITEMS
    {
        func1_AI_2_hi_alm_unacknowledged,
        func1_AI_2_hi_alm_state,
        func1_AI_2_hi_alm_subcode,
        func1_AI_2_hi_lim          (READ_ONLY),
        func1_AI_2_hi_alm_value
    }
}

MENU Page_lower_limit_warning_func1_AI_2
{
    LABEL        [limit_lo];
    ITEMS
    {
        func1_AI_2_lo_alm_unacknowledged,
        func1_AI_2_lo_alm_state,
        func1_AI_2_lo_alm_subcode,
        func1_AI_2_lo_lim          (READ_ONLY),
        func1_AI_2_lo_alm_value
    }
}

MENU Page_lower_limit_alarm_func1_AI_2
{
    LABEL        [limit_lo_lo];
    ITEMS
    {
        func1_AI_2_lo_lo_alm_unacknowledged,
        func1_AI_2_lo_lo_alm_state,
        func1_AI_2_lo_lo_alm_subcode,
        func1_AI_2_lo_lo_lim          (READ_ONLY),
        func1_AI_2_lo_lo_alm_value
    }
}

MENU Page_diagnosis_func1_AI_2
{
    LABEL        "AI-2";
    ITEMS
    {
        func1_AI_2_blk_object,
        func1_AI_2_blk_parent_class,
        func1_AI_2_blk_class,
        func1_AI_2_blk_dd_reference,
        func1_AI_2_blk_dd_rev,
        func1_AI_2_blk_profile,
        func1_AI_2_blk_profile_rev,
        func1_AI_2_st_rev,
        func1_AI_2_actual_mode,
        func1_AI_2_simulation_enabled (READ_ONLY)
    }
}

/*---------------------------------------------------------------------*/
/*    AI-2 : Online-Dialogs                                            */
/*---------------------------------------------------------------------*/

MENU OnlineDialog_simulation_AI_2
{
	LABEL		"Simulate AI-2";
	ITEMS
	{
		Page_simulation_input_func1_AI_2,
		Page_simulation_output_func1_AI_2
	}
}

MENU Page_simulation_input_func1_AI_2
{
    LABEL        "AI2 Simulation (Measured Value)";
    ITEMS
    {
        func1_AI_2_simulation_enabled,
        Group_simulate_input_func1_AI_2
    }
}

MENU Group_simulate_input_func1_AI_2
{
    LABEL        [func_simulate_value];
    ITEMS
    {
        func1_AI_2_simulate_value,
        COLUMNBREAK,
        func1_AI_2_simulate_status_quality,
        func1_AI_2_simulate_status_limit
    }
}

MENU Page_simulation_output_func1_AI_2
{
    LABEL        "AI2 Simulation (Output)";
    ITEMS
    {
        func1_AI_2_target_mode,
        func1_AI_2_actual_mode,
        Group_simulate_output_func1_AI_2
    }
    POST_EDIT_ACTIONS
    {
        method_AI_2_target_mode,
    }
}

MENU Group_simulate_output_func1_AI_2
{
    LABEL        [func_out_value];
    ITEMS
    {

        func1_AI_2_out_value,
        COLUMNBREAK,
        func1_AI_2_out_status_quality,
        func1_AI_2_out_status_limit
    }
}

MENU OnlineDialog_AI_2_setting
{
    LABEL "AI-2 Block Mode";
    ITEMS
    {
        Page_func1_AI_2_mode
    }
}

MENU Page_func1_AI_2_mode
{
    LABEL [MC_Config_Block_Mode];
    ITEMS
    {
        Group_AI_2_mode,
        Group_AI_2_out_value,
        func1_AI_2_current_state_alarm_sum,
        method_set
    }
    POST_EDIT_ACTIONS
    {
        method_AI_2_target_mode
    }
}

MENU Group_AI_2_mode
{
    LABEL [MC_Select_Block_Mode];
    ITEMS
    {
        func1_AI_2_target_mode,
        COLUMNBREAK,
        func1_AI_2_actual_mode
    }
    POST_EDIT_ACTIONS
    {
        method_AI_2_target_mode
    }
}

MENU Group_AI_2_out_value
{
    LABEL [MC_Output];
    ITEMS
    {
        func1_AI_2_out_value,
        COLUMNBREAK,
        func1_AI_2_out_status_quality,
        func1_AI_2_out_status_limit
    }
}

/*---------------------------------------------------------------------*/
/*    AI-2 : Offline-Windows                                           */
/*---------------------------------------------------------------------*/

MENU OfflineWindow_AI_2_geral
{
    LABEL "AI-2";
    ITEMS
    {
        Page_AI_2_Basic_Settings,
        Page_AI_2_Advanced_Settings,
        Page_AI_2_Batch_Info
    }
}

MENU Page_AI_2_Basic_Settings
{
    LABEL [MC_Tab_basic];
    ITEMS
    {
        Group_AI_2_Select_Input,
        Group_AI_2_Process_Value_Scale,
        Group_AI_2_Output_Scale_Unit,
        Group_AI_2_Set_filter_Time
    }
}

MENU Group_AI_2_Select_Input
{
    LABEL [MC_Tab_channel];
    ITEMS
    {
        func1_AI_2_channel,
        COLUMNBREAK,
        method_write_func1_AI_2_channel
    }
}

MENU Group_AI_2_Process_Value_Scale
{
    LABEL [MC_Process_Value_Scale];
    ITEMS
    {
        func1_AI_2_pv_lower_range_value,
        func1_AI_2_pv_upper_range_value,
        COLUMNBREAK,
        method_write_func1_AI_2_pv
    }
}

MENU Group_AI_2_Output_Scale_Unit
{
    LABEL [MC_Tab_outscale_ai];
    ITEMS
    {
        func1_AI_2_out_lower_range_value,
        func1_AI_2_out_upper_range_value,
        func1_AI_2_out_unit,
        func1_AI_2_out_decimal_point,
        COLUMNBREAK,
        method_write_func1_AI_2_out_scale
    }
}

MENU Group_AI_2_Set_filter_Time
{
    LABEL [MC_Tab_filter_ai];
    ITEMS
    {
        func1_AI_2_pv_ftime,
        COLUMNBREAK,
        method_write_func1_AI_2_pv_ftime
    }
}

MENU Page_AI_2_Advanced_Settings
{
    LABEL [MC_Tab_advanced];
    ITEMS
    {
        Group_AI_2_Set_Alarm_Warning_Limits,
        Group_AI_2_Set_Fail_Safe_Values
    }
}

MENU Group_AI_2_Set_Alarm_Warning_Limits
{
    LABEL [MC_Set_Alarm_Warning_Limits];
    ITEMS
    {
        func1_AI_2_lo_lo_lim,
        func1_AI_2_lo_lim,
        func1_AI_2_hi_lim,
        func1_AI_2_hi_hi_lim,
        func1_AI_2_alarm_hys,
        func1_AI_2_out_unit  (READ_ONLY)
        COLUMNBREAK,
        method_write_AI_2_Set_Alarm_Warning_Limits
    }
}

MENU Group_AI_2_Set_Fail_Safe_Values
{
    LABEL [MC_Set_Fail_Safe_Values];
    ITEMS
    {
        func1_AI_2_FSafeType,
        func1_AI_2_FSafeValue
        COLUMNBREAK,
        method_write_AI_2_Set_Fail_Safe_Values
    }
}

MENU Page_AI_2_Batch_Info
{
    LABEL [MC_Batch_Info];
    ITEMS
    {
        Group_AI_2_Define_Batch_Information
    }
}

MENU Group_AI_2_Define_Batch_Information
{
    LABEL [MC_Define_Batch_Info];
    ITEMS
    {
        func1_AI_2_batch_id,
        func1_AI_2_batch_unit,
        func1_AI_2_batch_operation,
        func1_AI_2_batch_phase
        COLUMNBREAK,
        method_write_func1_AI_2_batch_information
    }
}


/*---------------------------------------------------------------------*/
/*    AI-2 : Methods                                                   */
/*---------------------------------------------------------------------*/

METHOD method_AI_2_target_mode
{
    LABEL [MC_method_target_mode];
    DEFINITION
    {
        WriteCommand (write_func1_AI_2_target_mode);
    }
}

METHOD method_write_func1_AI_2_channel
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_2_channel);
        ReadCommand(read_func1_AI_2_channel);
    }
}

METHOD method_write_func1_AI_2_pv
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_2_pv);
        ReadCommand(read_func1_AI_2_pv);
    }
}

METHOD method_write_func1_AI_2_out_scale
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_2_out_scale);
        ReadCommand(read_func1_AI_2_out_scale);
    }
}

METHOD method_write_func1_AI_2_pv_ftime
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_2_pv_ftime);
        ReadCommand(read_func1_AI_2_pv_ftime);
    }
}

METHOD method_write_AI_2_Set_Alarm_Warning_Limits
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_2_lo_lo_lim);
        WriteCommand(write_func1_AI_2_lo_lim);
        WriteCommand(write_func1_AI_2_hi_lim);
        WriteCommand(write_func1_AI_2_hi_hi_lim);
        WriteCommand(write_func1_AI_2_alarm_hys);
        ReadCommand(read_func1_AI_2_lo_lo_lim);
        ReadCommand(read_func1_AI_2_lo_lim);
        ReadCommand(read_func1_AI_2_hi_lim);
        ReadCommand(read_func1_AI_2_hi_hi_lim);
        ReadCommand(read_func1_AI_2_alarm_hys);
    }
}

METHOD method_write_AI_2_Set_Fail_Safe_Values
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_2_FSafeType);
        WriteCommand(write_func1_AI_2_FSafeValue);
        ReadCommand(read_func1_AI_2_FSafeType);
        ReadCommand(read_func1_AI_2_FSafeValue);
    }
}

METHOD method_write_func1_AI_2_batch_information
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_2_batch_information);
        ReadCommand(read_func1_AI_2_batch_information);
    }
}

/***********************************************************************/
/*    AI Function Block 3                                              */
/***********************************************************************/

BLOCK func1_AI_3
{
    TYPE    FUNCTION;
    NUMBER  3;
}

func1_AI_3_blk_reserve                      LIKE VARIABLE    phys_blk_reserve
{
}

VARIABLE func1_AI_3_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [blk_block_object_FUNCTION]        }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_3_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [func_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    1,    [func_blk_parent_class_INPUT]    }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_3_blk_class
{
    LABEL       [blk_class];
    HELP        [func_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    1,    [func_blk_class_AI]            }
    }
    HANDLING    READ;
}

func1_AI_3_blk_dd_reference                 LIKE VARIABLE    phys_blk_dd_reference
{
}

func1_AI_3_blk_dd_rev                       LIKE VARIABLE    phys_blk_dd_rev
{
}

func1_AI_3_blk_profile                      LIKE VARIABLE    phys_blk_profile
{
}

func1_AI_3_blk_profile_rev                  LIKE VARIABLE    phys_blk_profile_rev
{
}

func1_AI_3_blk_execution_time               LIKE VARIABLE    phys_blk_execution_time
{
}

func1_AI_3_blk_num_parameters               LIKE VARIABLE    phys_blk_num_parameters
{
}

func1_AI_3_blk_index_view_1                 LIKE VARIABLE    phys_blk_index_view_1
{
}

func1_AI_3_blk_num_view_lists               LIKE VARIABLE    phys_blk_num_view_lists
{
}

func1_AI_3_st_rev                           LIKE VARIABLE    phys_st_rev
{
}

func1_AI_3_tag_desc                         LIKE VARIABLE    phys_tag_desc
{
    REDEFINE LABEL        [MC_AI_3_tag_desc];
    TYPE                ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}

func1_AI_3_strategy                         LIKE VARIABLE    phys_strategy
{
}

func1_AI_3_alert_key                        LIKE VARIABLE    phys_alert_key
{
}

VARIABLE func1_AI_3_target_mode
{
    LABEL       [target_mode];
    HELP        [target_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0x08;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_actual_mode
{
    LABEL       [actual_mode];
    HELP        [actual_mode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0x08;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_3_permitted_mode
{
    LABEL       [permitted_mode];
    HELP        [permitted_mode_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE    0x98;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_3_normal_mode
{
    LABEL       [normal_mode];
    HELP        [normal_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0x08;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

func1_AI_3_current_state_alarm_sum          LIKE VARIABLE    phys_current_state_alarm_sum
{
    REDEFINE LABEL      [MC_alarm_sum];
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func1_AI_3_unacknowledged_state_alarm_sum   LIKE VARIABLE    phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func1_AI_3_unreported_state_alarm_sum       LIKE VARIABLE    phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func1_AI_3_disabled_state_alarm_sum         LIKE VARIABLE    phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func1_AI_3_batch_id
{
    LABEL       [func_batch_id];
    HELP        [func_batch_id_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_batch_unit
{
    LABEL       [func_batch_unit];
    HELP        [func_batch_unit_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_batch_operation
{
    LABEL       [func_batch_operation];
    HELP        [func_batch_operation_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_batch_phase
{
    LABEL       [func_batch_phase];
    HELP        [func_batch_phase_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    AI-3 : Additional Parameter                                      */
/*---------------------------------------------------------------------*/

VARIABLE func1_AI_3_out_value
{
    LABEL       [func_out_value];
    HELP        [func_ai_out_value_help];
    CLASS       OUTPUT&DYNAMIC;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING
        IF (func1_AI_3_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}

VARIABLE func1_AI_3_out_status_quality
{
    LABEL       [status_quality];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING
        IF (func1_AI_3_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}

func1_AI_3_out_status_limit                 LIKE VARIABLE    func1_AI_3_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func1_AI_3_pv_upper_range_value
{
    LABEL       [func_pv_scale_upper_value];
    HELP        [func_pv_scale_upper_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_pv_lower_range_value
{
    LABEL       [func_pv_scale_lower_value];
    HELP        [func_pv_scale_lower_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_out_upper_range_value
{
    LABEL       [func_out_scale_upper_value];
    HELP        [func_out_scale_upper_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_out_lower_range_value
{
    LABEL       [func_out_scale_lower_value];
    HELP        [func_out_scale_lower_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_out_unit
{
    LABEL       [digital_units];
    HELP        [digital_units_help];
    CLASS       CONTAINED & SERVICE;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE  1342;
        UNIT_LIST
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_out_decimal_point
{
    LABEL       [decimal_point];
    HELP        [decimal_point_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    2;
        {    0,   "0"        },
        {    1,   "1"        },
        {    2,   "2"        },
        {    3,   "3"        },
        {    4,   "4"        },
        {    5,   "5"        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_lin_type
{
    LABEL       [trans_lin_type];
    HELP        [trans_lin_type_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {     0, [linear]               },
        {    10, [lin_type_SQUARE_ROOT] }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_channel
{
    LABEL       [func_channel];
    HELP        [func_channel_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   3;
        {1,    "Mod_In_1(TB)"              },
        {2,    "Mod_In_2(TB)"              },
        {3,    "Mod_In_3(TB)"              },
        {4,    "Mod_In_4(TB)"              }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_pv_ftime
{
    LABEL       [func_pv_ftime];
    HELP        [func_pv_ftime_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
        DISPLAY_FORMAT ".1f";
    }
    CONSTANT_UNIT    [sec];
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_FSafeType
{
    LABEL     [func_failsafetype];
    HELP      [func_ai_fsafe_type];
    CLASS     CONTAINED;
    TYPE      ENUMERATED(1)
    {
        DEFAULT_VALUE    1;
        { 0,[func_ai_fsafe_type_FAIL_SAFE_VALUE]       },
        { 1,[func_ai_fsafe_type_STORING_LAST_SETPOINT] },
        { 2,[func_ai_fsafe_type_FAIL_SAFE_POSITION]    }
    }
    HANDLING  READ & WRITE;
}

VARIABLE func1_AI_3_FSafeValue
{
    LABEL     [func_failsafevalue];
    /*
    HELP      [];
    */
    CLASS     CONTAINED;
    TYPE      FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING  READ & WRITE;
}

VARIABLE func1_AI_3_alarm_hys
{
    LABEL       [limit_hysteresis];
    HELP        [limit_hysteresis_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    CONSTANT_UNIT     [Percent];
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_hi_hi_lim
{
    LABEL       [limit_hi_hi];
    HELP        [limit_hi_hi_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_hi_lim
{
    LABEL       [limit_hi];
    HELP        [limit_hi_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_lo_lim
{
    LABEL       [limit_lo];
    HELP        [limit_lo_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_lo_lo_lim
{
    LABEL       [limit_lo_lo];
    HELP        [limit_lo_lo_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_hi_hi_alm_unacknowledged
{
    LABEL       [limit_alarm_unacknowledged];
    HELP        [limit_alarm_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_3_hi_hi_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_hi_hi_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_ALARM]    },
        {    1,    [limit_state_HI_HI]       }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_3_hi_hi_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_3_hi_hi_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_hi_hi_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_3_hi_hi_alm_value
{
    LABEL       [limit_alarm_value];
    HELP        [limit_hi_hi_alarm_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_3_hi_alm_unacknowledged
{
    LABEL       [limit_warn_unacknowledged];
    HELP        [limit_warn_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_3_hi_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_hi_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_WARNING]    },
        {    1,    [limit_state_HI]            }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_3_hi_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_3_hi_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_hi_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_3_hi_alm_value
{
    LABEL       [limit_warn_value];
    HELP        [limit_hi_warn_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_3_lo_alm_unacknowledged
{
    LABEL       [limit_warn_unacknowledged];
    HELP        [limit_warn_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_3_lo_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_lo_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_WARNING]    },
        {    1,    [limit_state_LO]            }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_3_lo_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_3_lo_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_lo_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_3_lo_alm_value
{
    LABEL       [limit_warn_value];
    HELP        [limit_lo_warn_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_3_lo_lo_alm_unacknowledged
{
    LABEL       [limit_alarm_unacknowledged];
    HELP        [limit_alarm_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_3_lo_lo_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_lo_lo_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_ALARM]        },
        {    1,    [limit_state_LO_LO]           }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_3_lo_lo_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_3_lo_lo_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_lo_lo_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_3_lo_lo_alm_value
{
    LABEL       [limit_alarm_value];
    HELP        [limit_lo_lo_alarm_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_3_simulate_status_quality
{
    LABEL       [status_quality];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    HANDLING    READ & WRITE;
}

func1_AI_3_simulate_status_limit            LIKE VARIABLE    func1_AI_3_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func1_AI_3_simulate_status_quality)
    }
}

VARIABLE func1_AI_3_simulate_value
{
    LABEL       [func_simulate_value];
    HELP        [func_ai_simulate_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_3_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_simulation_enabled
{
    LABEL       [func_simulation_enabled];
    HELP        [func_simulation_enabled_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [disabled]       },
        {    1,    [enabled]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_3_out_unit_text
{
    LABEL   [func_out_unit_text] ;
    HELP    [func_out_unit_text_help] ;
    CLASS   CONTAINED ;
    TYPE    ASCII(16) ;
    HANDLING READ & WRITE ;
}

/*---------------------------------------------------------------------*/
/*    AI-3 : Units                                                     */
/*---------------------------------------------------------------------*/

UNIT AI_3_OUT_SCALE_UNIT
{
    func1_AI_3_out_unit:

    func1_AI_3_out_value,
    func1_AI_3_out_upper_range_value,
    func1_AI_3_out_lower_range_value,
    func1_AI_3_hi_hi_lim,
    func1_AI_3_hi_lim,
    func1_AI_3_lo_lim,
    func1_AI_3_lo_lo_lim,
    func1_AI_3_hi_hi_alm_value,
    func1_AI_3_hi_alm_value,
    func1_AI_3_lo_alm_value,
    func1_AI_3_lo_lo_alm_value,
    func1_AI_3_FSafeValue
}

/***********************************************************************/
/*    AI-3 : COMMAND                                                   */
/***********************************************************************/

COMMAND read_func1_AI_3_blk
{
    BLOCK func1_AI_3;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_blk_reserve,
            func1_AI_3_blk_object,
            func1_AI_3_blk_parent_class,
            func1_AI_3_blk_class,
            func1_AI_3_blk_dd_reference,
            func1_AI_3_blk_dd_rev,
            func1_AI_3_blk_profile,
            func1_AI_3_blk_profile_rev,
            func1_AI_3_blk_execution_time,
            func1_AI_3_blk_num_parameters,
            func1_AI_3_blk_index_view_1,
            func1_AI_3_blk_num_view_lists
        }
    }
}

COMMAND read_func1_AI_3_st_rev
{
    BLOCK func1_AI_3;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_st_rev
        }
    }
}


COMMAND read_func1_AI_3_tag_desc
{
    BLOCK func1_AI_3;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_tag_desc
        }
    }
}

COMMAND write_func1_AI_3_tag_desc
{
    BLOCK func1_AI_3;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_tag_desc
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_strategy
{
    BLOCK func1_AI_3;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_strategy
        }
    }
}

COMMAND write_func1_AI_3_strategy
{
    BLOCK func1_AI_3;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_strategy
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_alert_key
{
    BLOCK func1_AI_3;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_alert_key
        }
    }
}

COMMAND write_func1_AI_3_alert_key
{
    BLOCK func1_AI_3;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_alert_key
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_target_mode
{
    BLOCK func1_AI_3;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_target_mode
        }
    }
}

COMMAND write_func1_AI_3_target_mode
{
    BLOCK func1_AI_3;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_target_mode
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_mode
{
    BLOCK func1_AI_3;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_actual_mode,
            func1_AI_3_permitted_mode,
            func1_AI_3_normal_mode
        }
    }
}

COMMAND read_func1_AI_3_alarm
{
    BLOCK func1_AI_3;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_current_state_alarm_sum,
            func1_AI_3_unacknowledged_state_alarm_sum,
            func1_AI_3_unreported_state_alarm_sum,
            func1_AI_3_disabled_state_alarm_sum
        }
    }
}

COMMAND read_func1_AI_3_batch_information
{
    BLOCK func1_AI_3;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_batch_id,
            func1_AI_3_batch_unit,
            func1_AI_3_batch_operation,
            func1_AI_3_batch_phase
        }
    }
}

COMMAND write_func1_AI_3_batch_information
{
    BLOCK func1_AI_3;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_batch_id,
            func1_AI_3_batch_unit,
            func1_AI_3_batch_operation,
            func1_AI_3_batch_phase
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_out
{
    BLOCK func1_AI_3;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_out_value,
            func1_AI_3_out_status_quality <0xFC>,
            func1_AI_3_out_status_limit   <0x03>
        }
    }
}

COMMAND write_func1_AI_3_out
{
    BLOCK func1_AI_3;
    INDEX 10;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_out_value,
            func1_AI_3_out_status_quality <0xFC>,
            func1_AI_3_out_status_limit   <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_pv
{
    BLOCK func1_AI_3;
    INDEX 11;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_pv_upper_range_value,
            func1_AI_3_pv_lower_range_value
        }
    }
}

COMMAND write_func1_AI_3_pv
{
    BLOCK func1_AI_3;
    INDEX 11;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_pv_upper_range_value,
            func1_AI_3_pv_lower_range_value
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_out_scale
{
    BLOCK func1_AI_3;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_out_upper_range_value,
            func1_AI_3_out_lower_range_value,
            func1_AI_3_out_unit,
            func1_AI_3_out_decimal_point
        }
    }
}

COMMAND write_func1_AI_3_out_scale
{
    BLOCK func1_AI_3;
    INDEX 12;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_out_upper_range_value,
            func1_AI_3_out_lower_range_value,
            func1_AI_3_out_unit,
            func1_AI_3_out_decimal_point
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_lin_type
{
    BLOCK func1_AI_3;
    INDEX 13;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_lin_type
        }
    }
}

COMMAND write_func1_AI_3_lin_type
{
    BLOCK func1_AI_3;
    INDEX 13;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_lin_type
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_channel
{
    BLOCK func1_AI_3;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_channel
        }
    }
}

COMMAND write_func1_AI_3_channel
{
    BLOCK func1_AI_3;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_channel
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_pv_ftime
{
    BLOCK func1_AI_3;
    INDEX 16;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_pv_ftime
        }
    }
}

COMMAND write_func1_AI_3_pv_ftime
{
    BLOCK func1_AI_3;
    INDEX 16;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_pv_ftime
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_FSafeType
{
    BLOCK func1_AI_3;
    INDEX 17;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_FSafeType
        }
    }
}

COMMAND write_func1_AI_3_FSafeType
{
    BLOCK func1_AI_3;
    INDEX 17;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_FSafeType
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_FSafeValue
{
    BLOCK func1_AI_3;
    INDEX 18;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_FSafeValue
        }
    }
}

COMMAND write_func1_AI_3_FSafeValue
{
    BLOCK func1_AI_3;
    INDEX 18;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_FSafeValue
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_alarm_hys
{
    BLOCK func1_AI_3;
    INDEX 19;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_alarm_hys
        }
    }
}


COMMAND write_func1_AI_3_alarm_hys
{
    BLOCK func1_AI_3;
    INDEX 19;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_alarm_hys
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_hi_hi_lim
{
    BLOCK func1_AI_3;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_hi_hi_lim
        }
    }
}

COMMAND write_func1_AI_3_hi_hi_lim
{
    BLOCK func1_AI_3;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_hi_hi_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_hi_lim
{
    BLOCK func1_AI_3;
    INDEX 23;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_hi_lim
        }
    }
}

COMMAND write_func1_AI_3_hi_lim
{
    BLOCK func1_AI_3;
    INDEX 23;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_hi_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_lo_lim
{
    BLOCK func1_AI_3;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_lo_lim
        }
    }
}

COMMAND write_func1_AI_3_lo_lim
{
    BLOCK func1_AI_3;
    INDEX 25;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_lo_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_lo_lo_lim
{
    BLOCK func1_AI_3;
    INDEX 27;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_lo_lo_lim
        }
    }
}

COMMAND write_func1_AI_3_lo_lo_lim
{
    BLOCK func1_AI_3;
    INDEX 27;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_lo_lo_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_3_hi_hi_alm
{
    BLOCK func1_AI_3;
    INDEX 30;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_hi_hi_alm_unacknowledged,
            func1_AI_3_hi_hi_alm_state,
            func1_AI_3_hi_hi_alm_time_stamp,
            func1_AI_3_hi_hi_alm_subcode,
            func1_AI_3_hi_hi_alm_value
        }
    }
}

COMMAND read_func1_AI_3_hi_alm
{
    BLOCK func1_AI_3;
    INDEX 31;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_hi_alm_unacknowledged,
            func1_AI_3_hi_alm_state,
            func1_AI_3_hi_alm_time_stamp,
            func1_AI_3_hi_alm_subcode,
            func1_AI_3_hi_alm_value
        }
    }
}

COMMAND read_func1_AI_3_lo_alm
{
    BLOCK func1_AI_3;
    INDEX 32;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_lo_alm_unacknowledged,
            func1_AI_3_lo_alm_state,
            func1_AI_3_lo_alm_time_stamp,
            func1_AI_3_lo_alm_subcode,
            func1_AI_3_lo_alm_value
        }
    }
}

COMMAND read_func1_AI_3_lo_lo_alm
{
    BLOCK func1_AI_3;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_lo_lo_alm_unacknowledged,
            func1_AI_3_lo_lo_alm_state,
            func1_AI_3_lo_lo_alm_time_stamp,
            func1_AI_3_lo_lo_alm_subcode,
            func1_AI_3_lo_lo_alm_value
        }
    }
}

COMMAND read_func1_AI_3_simulate
{
    BLOCK func1_AI_3;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_simulate_status_quality <0xFC>,
            func1_AI_3_simulate_status_limit <0x03>,
            func1_AI_3_simulate_value,
            func1_AI_3_simulation_enabled
        }
    }
}

COMMAND write_func1_AI_3_simulate
{
    BLOCK func1_AI_3;
    INDEX 34;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_simulate_status_quality <0xFC>,
            func1_AI_3_simulate_status_limit <0x03>,
            func1_AI_3_simulate_value,
            func1_AI_3_simulation_enabled
        }
        REPLY
        {
        }
    }
}


COMMAND read_func1_AI_3_out_unit_text
{
    BLOCK func1_AI_3;
    INDEX 35;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_3_out_unit_text
        }
    }
}

COMMAND write_func1_AI_3_out_unit_text
{
    BLOCK func1_AI_3;
    INDEX 35;
    OPERATION WRITE ;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_3_out_unit_text
        }
        REPLY
        {
        }
    }
}

/***********************************************************************/
/*    AI-3 : MENUs                                                     */
/***********************************************************************/

/*---------------------------------------------------------------------*/
/*    AI-3 : (Table - Specialist)                                      */
/*---------------------------------------------------------------------*/

MENU Tab_s_AI_3
{
    LABEL        "AI-3";
    ITEMS
    {
        func1_AI_3_st_rev
        Tab_s_AI_3_basic,
        Tab_s_AI_3_advanced
    }
}

MENU Tab_s_AI_3_basic
{
    LABEL        [MC_Tab_basic];
    ITEMS
    {
        Tab_s_AI_3_target_mode,
        Tab_s_AI_3_channel,
        Tab_s_func1_AI_3_pv_range,
        Tab_s_AI_3_outscale,
        Tab_s_AI_3_filter
    }
}

MENU Tab_s_AI_3_target_mode
{
    LABEL        [MC_Tab_mode_ai];
    ITEMS
    {
        func1_AI_3_target_mode
    }
}

MENU Tab_s_AI_3_channel
{
    LABEL        [MC_Tab_channel];
    ITEMS
    {
        func1_AI_3_channel
    }
}

MENU Tab_s_func1_AI_3_pv_range
{
    LABEL        [menu_input_measwindow];
    ITEMS
    {
        func1_AI_3_pv_lower_range_value,
        func1_AI_3_pv_upper_range_value
    }
}

MENU Tab_s_AI_3_outscale
{
    LABEL        [MC_Tab_outscale_ai];
    ITEMS
    {
        func1_AI_3_out_lower_range_value,
        func1_AI_3_out_upper_range_value,
        func1_AI_3_out_unit,
        func1_AI_3_out_decimal_point
    }
}

MENU Tab_s_AI_3_filter
{
    LABEL        [MC_Tab_filter_ai];
    ITEMS
    {
        func1_AI_3_pv_ftime
    }
}

MENU Tab_s_AI_3_advanced
{
    LABEL        [MC_Tab_advanced];
    ITEMS
    {
        Tab_s_func1_AI_3_limits,
        Tab_s_func1_AI_3_FSafe,
        Tab_s_func1_AI_3_batch
    }
}

MENU Tab_s_func1_AI_3_limits
{
    LABEL        [menu_output_limits];
    ITEMS
    {
        func1_AI_3_lo_lo_lim,
        func1_AI_3_lo_lim,
        func1_AI_3_hi_lim,
        func1_AI_3_hi_hi_lim,
        func1_AI_3_alarm_hys
    }
}

MENU Tab_s_func1_AI_3_FSafe
{
    LABEL        [menu_fail_safe];
    ITEMS
    {
        func1_AI_3_FSafeType,
        func1_AI_3_FSafeValue
    }
}

MENU Tab_s_func1_AI_3_batch
{
    LABEL        [menu_ident_batch_info];
    ITEMS
    {
        func1_AI_3_batch_id,
        func1_AI_3_batch_unit,
        func1_AI_3_batch_operation,
        func1_AI_3_batch_phase
    }
}

/*---------------------------------------------------------------------*/
/*    AI-3 : (Table - Maintenance)                                     */
/*---------------------------------------------------------------------*/

MENU Tab_m_AI_3
{
    LABEL        "AI-3";
    ITEMS
    {
        func1_AI_3_st_rev,
        Tab_m_AI_3_basic,
        Tab_m_AI_3_advanced
    }
}

MENU Tab_m_AI_3_basic
{
    LABEL        [MC_Tab_basic];
    ITEMS
    {
        Tab_m_AI_3_target_mode,
        Tab_m_AI_3_channel,
        Tab_m_func1_AI_3_pv_range,
        Tab_m_AI_3_outscale,
        Tab_m_AI_3_filter
    }
}

MENU Tab_m_AI_3_target_mode
{
    LABEL        [MC_Tab_mode_ai];
    ITEMS
    {
        func1_AI_3_target_mode    (READ_ONLY),
        func1_AI_3_actual_mode,
        func1_AI_3_permitted_mode,
        func1_AI_3_normal_mode
    }
}

MENU Tab_m_AI_3_channel
{
    LABEL        [MC_Tab_channel];
    ITEMS
    {
        func1_AI_3_channel        (READ_ONLY)
    }
}

MENU Tab_m_func1_AI_3_pv_range
{
    LABEL        [menu_input_measwindow];
    ITEMS
    {
        func1_AI_3_pv_lower_range_value   (READ_ONLY),
        func1_AI_3_pv_upper_range_value   (READ_ONLY)
    }
}

MENU Tab_m_AI_3_outscale
{
    LABEL        [MC_Tab_outscale_ai];
    ITEMS
    {
        func1_AI_3_out_lower_range_value  (READ_ONLY),
        func1_AI_3_out_upper_range_value  (READ_ONLY),
        func1_AI_3_out_unit               (READ_ONLY),
        func1_AI_3_out_decimal_point
    }
}

MENU Tab_m_AI_3_filter
{
    LABEL        [MC_Tab_filter_ai];
    ITEMS
    {
        func1_AI_3_pv_ftime           (READ_ONLY)
    }
}

MENU Tab_m_AI_3_advanced
{
    LABEL        [MC_Tab_advanced];
    ITEMS
    {
        Tab_m_func1_AI_3_limits,
        Tab_m_func1_AI_3_FSafe,
        Tab_m_func1_AI_3_batch
    }
}

MENU Tab_m_func1_AI_3_limits
{
    LABEL        [menu_output_limits];
    ITEMS
    {
        func1_AI_3_lo_lo_lim  (READ_ONLY),
        func1_AI_3_lo_lim     (READ_ONLY),
        func1_AI_3_hi_lim     (READ_ONLY),
        func1_AI_3_hi_hi_lim  (READ_ONLY),
        func1_AI_3_alarm_hys  (READ_ONLY)
    }
}

MENU Tab_m_func1_AI_3_FSafe
{
    LABEL        [menu_fail_safe];
    ITEMS
    {
        func1_AI_3_FSafeType  (READ_ONLY),
        func1_AI_3_FSafeValue (READ_ONLY)
    }
}

MENU Tab_m_func1_AI_3_batch
{
    LABEL        [menu_ident_batch_info];
    ITEMS
    {
        func1_AI_3_batch_id,
        func1_AI_3_batch_unit,
        func1_AI_3_batch_operation,
        func1_AI_3_batch_phase
    }
}

/*---------------------------------------------------------------------*/
/*    AI-3 : Online-Windows                                            */
/*---------------------------------------------------------------------*/

MENU Page_display_func1_AI_3
{
    LABEL        "AI-3";
    ITEMS
    {
        BarVal_display_func1_AI_3,
        Group_display_func1_AI_3_output,
        Group_display_func1_AI_3_input
    }
}

MENU BarVal_display_func1_AI_3
{
    LABEL        [MC_Output_Value];
    ITEMS
    {
        func1_AI_3_out_value                  (READ_ONLY),
        func1_AI_3_out_lower_range_value      (READ_ONLY),
        func1_AI_3_out_upper_range_value      (READ_ONLY)
    }
}

MENU Group_display_func1_AI_3_output
{
    LABEL        [MC_Output];
    ITEMS
    {
        func1_AI_3_actual_mode,
        COLUMNBREAK,
        func1_AI_3_out_status_quality         (READ_ONLY),
        func1_AI_3_out_status_limit           (READ_ONLY),
        func1_AI_3_current_state_alarm_sum
    }
}

MENU Group_display_func1_AI_3_input
{
    LABEL        [MC_Input];
    ITEMS
    {
        func1_AI_3_channel                (READ_ONLY),
        COLUMNBREAK,
        func1_AI_3_simulation_enabled     (READ_ONLY)
    }
}

MENU OnlineWindow_S_alarm_func1_AI_3
{
    LABEL        "AI-3";
    ITEMS
    {
        Page_overview_func1_AI_3,
        Page_alarm_sum_func1_AI_3,
        Page_upper_limit_alarm_func1_AI_3,
        Page_upper_limit_warning_func1_AI_3,
        Page_lower_limit_warning_func1_AI_3,
        Page_lower_limit_alarm_func1_AI_3
    }
}

MENU Page_overview_func1_AI_3
{
    LABEL        [menu_dialog_overview];
    ITEMS
    {
        func1_AI_3_hi_hi_lim          (READ_ONLY),
        func1_AI_3_hi_lim             (READ_ONLY),
        func1_AI_3_lo_lim             (READ_ONLY),
        func1_AI_3_lo_lo_lim          (READ_ONLY),
        COLUMNBREAK,
        func1_AI_3_hi_hi_alm_state    (NO_LABEL),
        func1_AI_3_hi_alm_state       (NO_LABEL),
        func1_AI_3_lo_alm_state       (NO_LABEL),
        func1_AI_3_lo_lo_alm_state    (NO_LABEL),
        COLUMNBREAK,
        func1_AI_3_hi_hi_alm_value    (NO_LABEL),
        func1_AI_3_hi_alm_value       (NO_LABEL),
        func1_AI_3_lo_alm_value       (NO_LABEL),
        func1_AI_3_lo_lo_alm_value    (NO_LABEL)
    }
}

MENU Page_alarm_sum_func1_AI_3
{
    LABEL        [menu_dialog_alarm_sum];
    ITEMS
    {
        func1_AI_3_current_state_alarm_sum,
        func1_AI_3_unacknowledged_state_alarm_sum,
        COLUMNBREAK,
        func1_AI_3_unreported_state_alarm_sum,
        func1_AI_3_disabled_state_alarm_sum
    }
}

MENU Page_upper_limit_alarm_func1_AI_3
{
    LABEL        [limit_hi_hi];
    ITEMS
    {
        func1_AI_3_hi_hi_alm_unacknowledged,
        func1_AI_3_hi_hi_alm_state,
        func1_AI_3_hi_hi_alm_subcode,
        func1_AI_3_hi_hi_lim          (READ_ONLY),
        func1_AI_3_hi_hi_alm_value
    }
}

MENU Page_upper_limit_warning_func1_AI_3
{
    LABEL        [limit_hi];
    ITEMS
    {
        func1_AI_3_hi_alm_unacknowledged,
        func1_AI_3_hi_alm_state,
        func1_AI_3_hi_alm_subcode,
        func1_AI_3_hi_lim          (READ_ONLY),
        func1_AI_3_hi_alm_value
    }
}

MENU Page_lower_limit_warning_func1_AI_3
{
    LABEL        [limit_lo];
    ITEMS
    {
        func1_AI_3_lo_alm_unacknowledged,
        func1_AI_3_lo_alm_state,
        func1_AI_3_lo_alm_subcode,
        func1_AI_3_lo_lim          (READ_ONLY),
        func1_AI_3_lo_alm_value
    }
}

MENU Page_lower_limit_alarm_func1_AI_3
{
    LABEL        [limit_lo_lo];
    ITEMS
    {
        func1_AI_3_lo_lo_alm_unacknowledged,
        func1_AI_3_lo_lo_alm_state,
        func1_AI_3_lo_lo_alm_subcode,
        func1_AI_3_lo_lo_lim          (READ_ONLY),
        func1_AI_3_lo_lo_alm_value
    }
}

MENU Page_diagnosis_func1_AI_3
{
    LABEL        "AI-3";
    ITEMS
    {
        func1_AI_3_blk_object,
        func1_AI_3_blk_parent_class,
        func1_AI_3_blk_class,
        func1_AI_3_blk_dd_reference,
        func1_AI_3_blk_dd_rev,
        func1_AI_3_blk_profile,
        func1_AI_3_blk_profile_rev,
        func1_AI_3_st_rev,
        func1_AI_3_actual_mode,
        func1_AI_3_simulation_enabled (READ_ONLY)
    }
}

/*---------------------------------------------------------------------*/
/*    AI-3 : Online-Dialogs                                            */
/*---------------------------------------------------------------------*/

MENU OnlineDialog_simulation_AI_3
{
	LABEL		"Simulate AI-3";
	ITEMS
	{
		Page_simulation_input_func1_AI_3,
		Page_simulation_output_func1_AI_3
	}
}

MENU Page_simulation_input_func1_AI_3
{
    LABEL        "AI3 Simulation (Measured Value)";
    ITEMS
    {
        func1_AI_3_simulation_enabled,
        Group_simulate_input_func1_AI_3
    }
}

MENU Group_simulate_input_func1_AI_3
{
    LABEL        [func_simulate_value];
    ITEMS
    {
        func1_AI_3_simulate_value,
        COLUMNBREAK,
        func1_AI_3_simulate_status_quality,
        func1_AI_3_simulate_status_limit
    }
}

MENU Page_simulation_output_func1_AI_3
{
    LABEL        "AI3 Simulation (Output)";
    ITEMS
    {
        func1_AI_3_target_mode,
        func1_AI_3_actual_mode,
        Group_simulate_output_func1_AI_3
    }
    POST_EDIT_ACTIONS
    {
        method_AI_3_target_mode,
    }
}

MENU Group_simulate_output_func1_AI_3
{
    LABEL        [func_out_value];
    ITEMS
    {

        func1_AI_3_out_value,
        COLUMNBREAK,
        func1_AI_3_out_status_quality,
        func1_AI_3_out_status_limit
    }
}

MENU OnlineDialog_AI_3_setting
{
    LABEL "AI-3 Block Mode";
    ITEMS
    {
        Page_func1_AI_3_mode
    }
}

MENU Page_func1_AI_3_mode
{
    LABEL [MC_Config_Block_Mode];
    ITEMS
    {
        Group_AI_3_mode,
        Group_AI_3_out_value,
        func1_AI_3_current_state_alarm_sum,
        method_set
    }
    POST_EDIT_ACTIONS
    {
        method_AI_3_target_mode,
    }
}

MENU Group_AI_3_mode
{
    LABEL [MC_Select_Block_Mode];
    ITEMS
    {
        func1_AI_3_target_mode,
        COLUMNBREAK,
        func1_AI_3_actual_mode
    }
    POST_EDIT_ACTIONS
    {
        method_AI_3_target_mode,
    }
}

MENU Group_AI_3_out_value
{
    LABEL [MC_Output];
    ITEMS
    {
        func1_AI_3_out_value,
        COLUMNBREAK,
        func1_AI_3_out_status_quality,
        func1_AI_3_out_status_limit
    }
}

/*---------------------------------------------------------------------*/
/*    AI-3 : Offline-Windows                                           */
/*---------------------------------------------------------------------*/

MENU OfflineWindow_AI_3_geral
{
    LABEL "AI-3";
    ITEMS
    {
        Page_AI_3_Basic_Settings,
        Page_AI_3_Advanced_Settings,
        Page_AI_3_Batch_Info
    }
}

MENU Page_AI_3_Basic_Settings
{
    LABEL [MC_Tab_basic];
    ITEMS
    {
        Group_AI_3_Select_Input,
        Group_AI_3_Process_Value_Scale,
        Group_AI_3_Output_Scale_Unit,
        Group_AI_3_Set_filter_Time
    }
}

MENU Group_AI_3_Select_Input
{
    LABEL [MC_Tab_channel];
    ITEMS
    {
        func1_AI_3_channel,
        COLUMNBREAK,
        method_write_func1_AI_3_channel
    }
}

MENU Group_AI_3_Process_Value_Scale
{
    LABEL [MC_Process_Value_Scale];
    ITEMS
    {
        func1_AI_3_pv_lower_range_value,
        func1_AI_3_pv_upper_range_value,
        COLUMNBREAK,
        method_write_func1_AI_3_pv
    }
}

MENU Group_AI_3_Output_Scale_Unit
{
    LABEL [MC_Tab_outscale_ai];
    ITEMS
    {
        func1_AI_3_out_lower_range_value,
        func1_AI_3_out_upper_range_value,
        func1_AI_3_out_unit,
        func1_AI_3_out_decimal_point,
        COLUMNBREAK,
        method_write_func1_AI_3_out_scale
    }
}

MENU Group_AI_3_Set_filter_Time
{
    LABEL [MC_Tab_filter_ai];
    ITEMS
    {
        func1_AI_3_pv_ftime,
        COLUMNBREAK,
        method_write_func1_AI_3_pv_ftime
    }
}

MENU Page_AI_3_Advanced_Settings
{
    LABEL [MC_Tab_advanced];
    ITEMS
    {
        Group_AI_3_Set_Alarm_Warning_Limits,
        Group_AI_3_Set_Fail_Safe_Values
    }
}

MENU Group_AI_3_Set_Alarm_Warning_Limits
{
    LABEL [MC_Set_Alarm_Warning_Limits];
    ITEMS
    {
        func1_AI_3_lo_lo_lim,
        func1_AI_3_lo_lim,
        func1_AI_3_hi_lim,
        func1_AI_3_hi_hi_lim,
        func1_AI_3_alarm_hys,
        func1_AI_3_out_unit  (READ_ONLY)
        COLUMNBREAK,
        method_write_AI_3_Set_Alarm_Warning_Limits
    }
}

MENU Group_AI_3_Set_Fail_Safe_Values
{
    LABEL [MC_Set_Fail_Safe_Values];
    ITEMS
    {
        func1_AI_3_FSafeType,
        func1_AI_3_FSafeValue
        COLUMNBREAK,
        method_write_AI_3_Set_Fail_Safe_Values
    }
}

MENU Page_AI_3_Batch_Info
{
    LABEL [MC_Batch_Info];
    ITEMS
    {
        Group_AI_3_Define_Batch_Information
    }
}

MENU Group_AI_3_Define_Batch_Information
{
    LABEL [MC_Define_Batch_Info];
    ITEMS
    {
        func1_AI_3_batch_id,
        func1_AI_3_batch_unit,
        func1_AI_3_batch_operation,
        func1_AI_3_batch_phase
        COLUMNBREAK,
        method_write_func1_AI_3_batch_information
    }
}

METHOD method_AI_3_target_mode
{
    LABEL [MC_method_target_mode];
    DEFINITION
    {
        WriteCommand (write_func1_AI_3_target_mode);
    }
}

METHOD method_write_func1_AI_3_channel
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_3_channel);
        ReadCommand(read_func1_AI_3_channel);
    }
}

METHOD method_write_func1_AI_3_pv
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_3_pv);
        ReadCommand(read_func1_AI_3_pv);
    }
}

METHOD method_write_func1_AI_3_out_scale
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_3_out_scale);
        ReadCommand(read_func1_AI_3_out_scale);
    }
}

METHOD method_write_func1_AI_3_pv_ftime
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_3_pv_ftime);
        ReadCommand(read_func1_AI_3_pv_ftime);
    }
}

METHOD method_write_AI_3_Set_Alarm_Warning_Limits
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_3_lo_lo_lim);
        WriteCommand(write_func1_AI_3_lo_lim);
        WriteCommand(write_func1_AI_3_hi_lim);
        WriteCommand(write_func1_AI_3_hi_hi_lim);
        WriteCommand(write_func1_AI_3_alarm_hys);
        ReadCommand(read_func1_AI_3_lo_lo_lim);
        ReadCommand(read_func1_AI_3_lo_lim);
        ReadCommand(read_func1_AI_3_hi_lim);
        ReadCommand(read_func1_AI_3_hi_hi_lim);
        ReadCommand(read_func1_AI_3_alarm_hys);
    }
}

METHOD method_write_AI_3_Set_Fail_Safe_Values
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_3_FSafeType);
        WriteCommand(write_func1_AI_3_FSafeValue);
        ReadCommand(read_func1_AI_3_FSafeType);
        ReadCommand(read_func1_AI_3_FSafeValue);
    }
}

METHOD method_write_func1_AI_3_batch_information
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_3_batch_information);
        ReadCommand(read_func1_AI_3_batch_information);
    }
}

/***********************************************************************/
/*    AI Function Block 4                                              */
/***********************************************************************/

BLOCK func1_AI_4
{
    TYPE    FUNCTION;
    NUMBER  4;
}

func1_AI_4_blk_reserve                      LIKE VARIABLE    phys_blk_reserve
{
}

VARIABLE func1_AI_4_blk_object
{
    LABEL       [blk_block_object];
    HELP        [blk_block_object_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    2,    [blk_block_object_FUNCTION]        }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_4_blk_parent_class
{
    LABEL       [blk_parent_class];
    HELP        [func_blk_parent_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    1,    [func_blk_parent_class_INPUT]    }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_4_blk_class
{
    LABEL       [blk_class];
    HELP        [func_blk_class_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED(1)
    {
        {    1,    [func_blk_class_AI]            }
    }
    HANDLING    READ;
}

func1_AI_4_blk_dd_reference                 LIKE VARIABLE    phys_blk_dd_reference
{
}

func1_AI_4_blk_dd_rev                       LIKE VARIABLE    phys_blk_dd_rev
{
}

func1_AI_4_blk_profile                      LIKE VARIABLE    phys_blk_profile
{
}

func1_AI_4_blk_profile_rev                  LIKE VARIABLE    phys_blk_profile_rev
{
}

func1_AI_4_blk_execution_time               LIKE VARIABLE    phys_blk_execution_time
{
}

func1_AI_4_blk_num_parameters               LIKE VARIABLE    phys_blk_num_parameters
{
}

func1_AI_4_blk_index_view_1                 LIKE VARIABLE    phys_blk_index_view_1
{
}

func1_AI_4_blk_num_view_lists               LIKE VARIABLE    phys_blk_num_view_lists
{
}

func1_AI_4_st_rev                           LIKE VARIABLE    phys_st_rev
{
}

func1_AI_4_tag_desc                         LIKE VARIABLE    phys_tag_desc
{
    REDEFINE LABEL        [MC_AI_4_tag_desc];
    TYPE                ASCII (32)
    {
        REDEFINE DEFAULT_VALUE  "";
    }
}

func1_AI_4_strategy                         LIKE VARIABLE    phys_strategy
{
}

func1_AI_4_alert_key                        LIKE VARIABLE    phys_alert_key
{
}

VARIABLE func1_AI_4_target_mode
{
    LABEL       [target_mode];
    HELP        [target_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0x08;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_actual_mode
{
    LABEL       [actual_mode];
    HELP        [actual_mode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0x08;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_4_permitted_mode
{
    LABEL       [permitted_mode];
    HELP        [permitted_mode_help];
    CLASS       CONTAINED;
    TYPE        BIT_ENUMERATED (1)
    {
        DEFAULT_VALUE    0x98;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_4_normal_mode
{
    LABEL       [normal_mode];
    HELP        [normal_mode_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0x08;
        {    0x08,    [mode_AUTO]              },
        {    0x10,    [mode_MAN]               },
        {    0x80,    [mode_OUT_OF_SERVICE]    }
    }
    HANDLING    READ;
}

func1_AI_4_current_state_alarm_sum          LIKE VARIABLE    phys_current_state_alarm_sum
{
    REDEFINE LABEL      [MC_alarm_sum];
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func1_AI_4_unacknowledged_state_alarm_sum   LIKE VARIABLE    phys_unacknowledged_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func1_AI_4_unreported_state_alarm_sum       LIKE VARIABLE    phys_unreported_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

func1_AI_4_disabled_state_alarm_sum            LIKE VARIABLE    phys_disabled_state_alarm_sum
{
    REDEFINE TYPE        BIT_ENUMERATED (2)
    {
        {    0x0000,    [limit_state_NO_ALARM]  },
        {    0x0200,    [limit_state_HI_HI]     },
        {    0x0400,    [limit_state_HI]        },
        {    0x0800,    [limit_state_LO_LO]     },
        {    0x1000,    [limit_state_LO]        }
    }
    REDEFINE STYLE      "MULTILINE 16 5" ;
}

VARIABLE func1_AI_4_batch_id
{
    LABEL       [func_batch_id];
    HELP        [func_batch_id_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (4)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_batch_unit
{
    LABEL       [func_batch_unit];
    HELP        [func_batch_unit_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_batch_operation
{
    LABEL       [func_batch_operation];
    HELP        [func_batch_operation_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_batch_phase
{
    LABEL       [func_batch_phase];
    HELP        [func_batch_phase_help];
    CLASS       CONTAINED;
    TYPE        UNSIGNED_INTEGER (2)
    {
        DEFAULT_VALUE    0;
    }
    HANDLING    READ & WRITE;
}

/*---------------------------------------------------------------------*/
/*    AI-4 : Additional Parameter                                      */
/*---------------------------------------------------------------------*/

VARIABLE func1_AI_4_out_value
{
    LABEL       [func_out_value];
    HELP        [func_ai_out_value_help];
    CLASS       OUTPUT&DYNAMIC;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING
        IF (func1_AI_4_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}

VARIABLE func1_AI_4_out_status_quality
{
    LABEL       [status_quality];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_OUTPUT_NO_RCAS
    }
    HANDLING
        IF (func1_AI_4_target_mode == BLOCK_MODE_MAN)
        {
            READ & WRITE;
        }
        ELSE
        {
            READ;
        }
}

func1_AI_4_out_status_limit                 LIKE VARIABLE    func1_AI_4_out_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_OUTPUT_LIMIT
    }
}

VARIABLE func1_AI_4_pv_upper_range_value
{
    LABEL       [func_pv_scale_upper_value];
    HELP        [func_pv_scale_upper_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_pv_lower_range_value
{
    LABEL       [func_pv_scale_lower_value];
    HELP        [func_pv_scale_lower_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_out_upper_range_value
{
    LABEL       [func_out_scale_upper_value];
    HELP        [func_out_scale_upper_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_out_lower_range_value
{
    LABEL       [func_out_scale_lower_value];
    HELP        [func_out_scale_lower_value_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_out_unit
{
    LABEL       [digital_units];
    HELP        [digital_units_help];
    CLASS       CONTAINED & SERVICE;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE  1342;
        UNIT_LIST
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_out_decimal_point
{
    LABEL       [decimal_point];
    HELP        [decimal_point_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    2;
        {    0,   "0"        },
        {    1,   "1"        },
        {    2,   "2"        },
        {    3,   "3"        },
        {    4,   "4"        },
        {    5,   "5"        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_lin_type
{
    LABEL       [trans_lin_type];
    HELP        [trans_lin_type_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {     0, [linear]               },
        {    10, [lin_type_SQUARE_ROOT] }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_channel
{
    LABEL       [func_channel];
    HELP        [func_channel_help];
    CLASS       CONTAINED;
    TYPE        ENUMERATED (2)
    {
        DEFAULT_VALUE   4;
        {1,    "Mod_In_1(TB)"              },
        {2,    "Mod_In_2(TB)"              },
        {3,    "Mod_In_3(TB)"              },
        {4,    "Mod_In_4(TB)"              }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_pv_ftime
{
    LABEL       [func_pv_ftime];
    HELP        [func_pv_ftime_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
        DISPLAY_FORMAT ".1f";
    }
    CONSTANT_UNIT    [sec];
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_FSafeType
{
    LABEL     [func_failsafetype];
    HELP      [func_ai_fsafe_type];
    CLASS     CONTAINED;
    TYPE      ENUMERATED(1)
    {
        DEFAULT_VALUE    1;
        { 0,[func_ai_fsafe_type_FAIL_SAFE_VALUE]       },
        { 1,[func_ai_fsafe_type_STORING_LAST_SETPOINT] },
        { 2,[func_ai_fsafe_type_FAIL_SAFE_POSITION]    }
    }
    HANDLING  READ & WRITE;
}

VARIABLE func1_AI_4_FSafeValue
{
    LABEL     [func_failsafevalue];
    /*
    HELP      [];
    */
    CLASS     CONTAINED;
    TYPE      FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING  READ & WRITE;
}

VARIABLE func1_AI_4_alarm_hys
{
    LABEL       [limit_hysteresis];
    HELP        [limit_hysteresis_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    CONSTANT_UNIT     [Percent];
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_hi_hi_lim
{
    LABEL       [limit_hi_hi];
    HELP        [limit_hi_hi_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_hi_lim
{
    LABEL       [limit_hi];
    HELP        [limit_hi_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  100.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_lo_lim
{
    LABEL       [limit_lo];
    HELP        [limit_lo_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_lo_lo_lim
{
    LABEL       [limit_lo_lo];
    HELP        [limit_lo_lo_help];
    CLASS       CONTAINED;
    TYPE        FLOAT
    {
        DEFAULT_VALUE  0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_hi_hi_alm_unacknowledged
{
    LABEL       [limit_alarm_unacknowledged];
    HELP        [limit_alarm_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_4_hi_hi_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_hi_hi_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_ALARM]    },
        {    1,    [limit_state_HI_HI]       }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_4_hi_hi_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_4_hi_hi_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_hi_hi_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_4_hi_hi_alm_value
{
    LABEL       [limit_alarm_value];
    HELP        [limit_hi_hi_alarm_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_4_hi_alm_unacknowledged
{
    LABEL       [limit_warn_unacknowledged];
    HELP        [limit_warn_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_4_hi_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_hi_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_WARNING]    },
        {    1,    [limit_state_HI]            }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_4_hi_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_4_hi_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_hi_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_4_hi_alm_value
{
    LABEL       [limit_warn_value];
    HELP        [limit_hi_warn_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_4_lo_alm_unacknowledged
{
    LABEL       [limit_warn_unacknowledged];
    HELP        [limit_warn_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_4_lo_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_lo_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_WARNING]    },
        {    1,    [limit_state_LO]            }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_4_lo_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_4_lo_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_lo_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_4_lo_alm_value
{
    LABEL       [limit_warn_value];
    HELP        [limit_lo_warn_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_4_lo_lo_alm_unacknowledged
{
    LABEL       [limit_alarm_unacknowledged];
    HELP        [limit_alarm_unacknowledged_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (1);
    HANDLING    READ;
}

VARIABLE func1_AI_4_lo_lo_alm_state
{
    LABEL       [limit_state];
    HELP        [limit_lo_lo_state_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [limit_state_NO_ALARM]        },
        {    1,    [limit_state_LO_LO]           }
    }
    HANDLING    READ;
}

VARIABLE func1_AI_4_lo_lo_alm_time_stamp
{
    LABEL       [limit_time_stamp];
    HELP        [limit_time_stamp_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        TIME;
    HANDLING    READ;
}

VARIABLE func1_AI_4_lo_lo_alm_subcode
{
    LABEL       [limit_subcode];
    HELP        [limit_lo_lo_subcode_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        UNSIGNED_INTEGER (2);
    HANDLING    READ;
}

VARIABLE func1_AI_4_lo_lo_alm_value
{
    LABEL       [limit_alarm_value];
    HELP        [limit_lo_lo_alarm_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING    READ;
}

VARIABLE func1_AI_4_simulate_status_quality
{
    LABEL       [status_quality];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        STATUS_INPUT_NO_RCAS
    }
    HANDLING    READ & WRITE;
}

func1_AI_4_simulate_status_limit            LIKE VARIABLE    func1_AI_4_simulate_status_quality
{
    REDEFINE LABEL       [status_limit];
    REDEFINE TYPE        ENUMERATED (1)
    {
        STATUS_INPUT_LIMIT (func1_AI_4_simulate_status_quality)
    }
}

VARIABLE func1_AI_4_simulate_value
{
    LABEL       [func_simulate_value];
    HELP        [func_ai_simulate_value_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        FLOAT
    {
        DEFAULT_VALUE    0.0;
        DISPLAY_FORMAT	DEF_DISPLAY_FORMAT(func1_AI_4_out_decimal_point)
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_simulation_enabled
{
    LABEL       [func_simulation_enabled];
    HELP        [func_simulation_enabled_help];
    CLASS       CONTAINED & DYNAMIC;
    TYPE        ENUMERATED (1)
    {
        DEFAULT_VALUE    0;
        {    0,    [disabled]        },
        {    1,    [enabled]        }
    }
    HANDLING    READ & WRITE;
}

VARIABLE func1_AI_4_out_unit_text
{
    LABEL   [func_out_unit_text] ;
    HELP    [func_out_unit_text_help] ;
    CLASS   CONTAINED ;
    TYPE    ASCII(16) ;
    HANDLING READ & WRITE ;
}

/*---------------------------------------------------------------------*/
/*    AI-4 : Units                                                     */
/*---------------------------------------------------------------------*/

UNIT AI_4_OUT_SCALE_UNIT
{
    func1_AI_4_out_unit:

    func1_AI_4_out_value,
    func1_AI_4_out_upper_range_value,
    func1_AI_4_out_lower_range_value,
    func1_AI_4_hi_hi_lim,
    func1_AI_4_hi_lim,
    func1_AI_4_lo_lim,
    func1_AI_4_lo_lo_lim,
    func1_AI_4_hi_hi_alm_value,
    func1_AI_4_hi_alm_value,
    func1_AI_4_lo_alm_value,
    func1_AI_4_lo_lo_alm_value,
    func1_AI_4_FSafeValue
}

/***********************************************************************/
/*    AI-4 : COMMAND                                                   */
/***********************************************************************/

COMMAND read_func1_AI_4_blk
{
    BLOCK func1_AI_4;
    INDEX 0;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_blk_reserve,
            func1_AI_4_blk_object,
            func1_AI_4_blk_parent_class,
            func1_AI_4_blk_class,
            func1_AI_4_blk_dd_reference,
            func1_AI_4_blk_dd_rev,
            func1_AI_4_blk_profile,
            func1_AI_4_blk_profile_rev,
            func1_AI_4_blk_execution_time,
            func1_AI_4_blk_num_parameters,
            func1_AI_4_blk_index_view_1,
            func1_AI_4_blk_num_view_lists
        }
    }
}

COMMAND read_func1_AI_4_st_rev
{
    BLOCK func1_AI_4;
    INDEX 1;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_st_rev
        }
    }
}


COMMAND read_func1_AI_4_tag_desc
{
    BLOCK func1_AI_4;
    INDEX 2;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_tag_desc
        }
    }
}

COMMAND write_func1_AI_4_tag_desc
{
    BLOCK func1_AI_4;
    INDEX 2;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_tag_desc
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_strategy
{
    BLOCK func1_AI_4;
    INDEX 3;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_strategy
        }
    }
}

COMMAND write_func1_AI_4_strategy
{
    BLOCK func1_AI_4;
    INDEX 3;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_strategy
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_alert_key
{
    BLOCK func1_AI_4;
    INDEX 4;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_alert_key
        }
    }
}

COMMAND write_func1_AI_4_alert_key
{
    BLOCK func1_AI_4;
    INDEX 4;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_alert_key
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_target_mode
{
    BLOCK func1_AI_4;
    INDEX 5;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_target_mode
        }
    }
}

COMMAND write_func1_AI_4_target_mode
{
    BLOCK func1_AI_4;
    INDEX 5;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_target_mode
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_mode
{
    BLOCK func1_AI_4;
    INDEX 6;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_actual_mode,
            func1_AI_4_permitted_mode,
            func1_AI_4_normal_mode
        }
    }
}

COMMAND read_func1_AI_4_alarm
{
    BLOCK func1_AI_4;
    INDEX 7;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_current_state_alarm_sum,
            func1_AI_4_unacknowledged_state_alarm_sum,
            func1_AI_4_unreported_state_alarm_sum,
            func1_AI_4_disabled_state_alarm_sum
        }
    }
}

COMMAND read_func1_AI_4_batch_information
{
    BLOCK func1_AI_4;
    INDEX 8;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_batch_id,
            func1_AI_4_batch_unit,
            func1_AI_4_batch_operation,
            func1_AI_4_batch_phase
        }
    }
}

COMMAND write_func1_AI_4_batch_information
{
    BLOCK func1_AI_4;
    INDEX 8;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_batch_id,
            func1_AI_4_batch_unit,
            func1_AI_4_batch_operation,
            func1_AI_4_batch_phase
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_out
{
    BLOCK func1_AI_4;
    INDEX 10;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_out_value,
            func1_AI_4_out_status_quality <0xFC>,
            func1_AI_4_out_status_limit   <0x03>
        }
    }
}

COMMAND write_func1_AI_4_out
{
    BLOCK func1_AI_4;
    INDEX 10;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_out_value,
            func1_AI_4_out_status_quality <0xFC>,
            func1_AI_4_out_status_limit   <0x03>
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_pv
{
    BLOCK func1_AI_4;
    INDEX 11;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_pv_upper_range_value,
            func1_AI_4_pv_lower_range_value
        }
    }
}

COMMAND write_func1_AI_4_pv
{
    BLOCK func1_AI_4;
    INDEX 11;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_pv_upper_range_value,
            func1_AI_4_pv_lower_range_value
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_out_scale
{
    BLOCK func1_AI_4;
    INDEX 12;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_out_upper_range_value,
            func1_AI_4_out_lower_range_value,
            func1_AI_4_out_unit,
            func1_AI_4_out_decimal_point
        }
    }
}

COMMAND write_func1_AI_4_out_scale
{
    BLOCK func1_AI_4;
    INDEX 12;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_out_upper_range_value,
            func1_AI_4_out_lower_range_value,
            func1_AI_4_out_unit,
            func1_AI_4_out_decimal_point
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_lin_type
{
    BLOCK func1_AI_4;
    INDEX 13;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_lin_type
        }
    }
}

COMMAND write_func1_AI_4_lin_type
{
    BLOCK func1_AI_4;
    INDEX 13;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_lin_type
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_channel
{
    BLOCK func1_AI_4;
    INDEX 14;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_channel
        }
    }
}

COMMAND write_func1_AI_4_channel
{
    BLOCK func1_AI_4;
    INDEX 14;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_channel
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_pv_ftime
{
    BLOCK func1_AI_4;
    INDEX 16;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_pv_ftime
        }
    }
}

COMMAND write_func1_AI_4_pv_ftime
{
    BLOCK func1_AI_4;
    INDEX 16;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_pv_ftime
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_FSafeType
{
    BLOCK func1_AI_4;
    INDEX 17;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_FSafeType
        }
    }
}

COMMAND write_func1_AI_4_FSafeType
{
    BLOCK func1_AI_4;
    INDEX 17;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_FSafeType
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_FSafeValue
{
    BLOCK func1_AI_4;
    INDEX 18;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_FSafeValue
        }
    }
}

COMMAND write_func1_AI_4_FSafeValue
{
    BLOCK func1_AI_4;
    INDEX 18;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_FSafeValue
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_alarm_hys
{
    BLOCK func1_AI_4;
    INDEX 19;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_alarm_hys
        }
    }
}


COMMAND write_func1_AI_4_alarm_hys
{
    BLOCK func1_AI_4;
    INDEX 19;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_alarm_hys
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_hi_hi_lim
{
    BLOCK func1_AI_4;
    INDEX 21;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_hi_hi_lim
        }
    }
}

COMMAND write_func1_AI_4_hi_hi_lim
{
    BLOCK func1_AI_4;
    INDEX 21;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_hi_hi_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_hi_lim
{
    BLOCK func1_AI_4;
    INDEX 23;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_hi_lim
        }
    }
}

COMMAND write_func1_AI_4_hi_lim
{
    BLOCK func1_AI_4;
    INDEX 23;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_hi_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_lo_lim
{
    BLOCK func1_AI_4;
    INDEX 25;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_lo_lim
        }
    }
}

COMMAND write_func1_AI_4_lo_lim
{
    BLOCK func1_AI_4;
    INDEX 25;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_lo_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_lo_lo_lim
{
    BLOCK func1_AI_4;
    INDEX 27;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_lo_lo_lim
        }
    }
}

COMMAND write_func1_AI_4_lo_lo_lim
{
    BLOCK func1_AI_4;
    INDEX 27;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_lo_lo_lim
        }
        REPLY
        {
        }
    }
}

COMMAND read_func1_AI_4_hi_hi_alm
{
    BLOCK func1_AI_4;
    INDEX 30;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_hi_hi_alm_unacknowledged,
            func1_AI_4_hi_hi_alm_state,
            func1_AI_4_hi_hi_alm_time_stamp,
            func1_AI_4_hi_hi_alm_subcode,
            func1_AI_4_hi_hi_alm_value
        }
    }
}

COMMAND read_func1_AI_4_hi_alm
{
    BLOCK func1_AI_4;
    INDEX 31;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_hi_alm_unacknowledged,
            func1_AI_4_hi_alm_state,
            func1_AI_4_hi_alm_time_stamp,
            func1_AI_4_hi_alm_subcode,
            func1_AI_4_hi_alm_value
        }
    }
}

COMMAND read_func1_AI_4_lo_alm
{
    BLOCK func1_AI_4;
    INDEX 32;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_lo_alm_unacknowledged,
            func1_AI_4_lo_alm_state,
            func1_AI_4_lo_alm_time_stamp,
            func1_AI_4_lo_alm_subcode,
            func1_AI_4_lo_alm_value
        }
    }
}

COMMAND read_func1_AI_4_lo_lo_alm
{
    BLOCK func1_AI_4;
    INDEX 33;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_lo_lo_alm_unacknowledged,
            func1_AI_4_lo_lo_alm_state,
            func1_AI_4_lo_lo_alm_time_stamp,
            func1_AI_4_lo_lo_alm_subcode,
            func1_AI_4_lo_lo_alm_value
        }
    }
}

COMMAND read_func1_AI_4_simulate
{
    BLOCK func1_AI_4;
    INDEX 34;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_simulate_status_quality <0xFC>,
            func1_AI_4_simulate_status_limit   <0x03>,
            func1_AI_4_simulate_value,
            func1_AI_4_simulation_enabled
        }
    }
}

COMMAND write_func1_AI_4_simulate
{
    BLOCK func1_AI_4;
    INDEX 34;
    OPERATION WRITE;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_simulate_status_quality <0xFC>,
            func1_AI_4_simulate_status_limit   <0x03>,
            func1_AI_4_simulate_value,
            func1_AI_4_simulation_enabled
        }
        REPLY
        {
        }
    }
}


COMMAND read_func1_AI_4_out_unit_text
{
    BLOCK func1_AI_4;
    INDEX 35;
    OPERATION READ;
    TRANSACTION
    {
        REQUEST
        {
        }
        REPLY
        {
            func1_AI_4_out_unit_text
        }
    }
}

COMMAND write_func1_AI_4_out_unit_text
{
    BLOCK func1_AI_4;
    INDEX 35;
    OPERATION WRITE ;
    TRANSACTION
    {
        REQUEST
        {
            func1_AI_4_out_unit_text
        }
        REPLY
        {
        }
    }
}

/***********************************************************************/
/*    AI-4 : MENUs                                                     */
/***********************************************************************/

/*---------------------------------------------------------------------*/
/*    AI-4 : (Table - Specialist)                                      */
/*---------------------------------------------------------------------*/

MENU Tab_s_AI_4
{
    LABEL        "AI-4";
    ITEMS
    {
        func1_AI_4_st_rev
        Tab_s_AI_4_basic,
        Tab_s_AI_4_advanced
    }
}

MENU Tab_s_AI_4_basic
{
    LABEL        [MC_Tab_basic];
    ITEMS
    {
        Tab_s_AI_4_target_mode,
        Tab_s_AI_4_channel,
        Tab_s_func1_AI_4_pv_range,
        Tab_s_AI_4_outscale,
        Tab_s_AI_4_filter
    }
}

MENU Tab_s_AI_4_target_mode
{
    LABEL        [MC_Tab_mode_ai];
    ITEMS
    {
        func1_AI_4_target_mode
    }
}

MENU Tab_s_AI_4_channel
{
    LABEL        [MC_Tab_channel];
    ITEMS
    {
        func1_AI_4_channel
    }
}

MENU Tab_s_func1_AI_4_pv_range
{
    LABEL        [menu_input_measwindow];
    ITEMS
    {
        func1_AI_4_pv_lower_range_value,
        func1_AI_4_pv_upper_range_value
    }
}

MENU Tab_s_AI_4_outscale
{
    LABEL        [MC_Tab_outscale_ai];
    ITEMS
    {
        func1_AI_4_out_lower_range_value,
        func1_AI_4_out_upper_range_value,
        func1_AI_4_out_unit,
        func1_AI_4_out_decimal_point
    }
}

MENU Tab_s_AI_4_filter
{
    LABEL        [MC_Tab_filter_ai];
    ITEMS
    {
        func1_AI_4_pv_ftime
    }
}

MENU Tab_s_AI_4_advanced
{
    LABEL        [MC_Tab_advanced];
    ITEMS
    {
        Tab_s_func1_AI_4_limits,
        Tab_s_func1_AI_4_FSafe,
        Tab_s_func1_AI_4_batch
    }
}

MENU Tab_s_func1_AI_4_limits
{
    LABEL        [menu_output_limits];
    ITEMS
    {
        func1_AI_4_lo_lo_lim,
        func1_AI_4_lo_lim,
        func1_AI_4_hi_lim,
        func1_AI_4_hi_hi_lim,
        func1_AI_4_alarm_hys
    }
}

MENU Tab_s_func1_AI_4_FSafe
{
    LABEL        [menu_fail_safe];
    ITEMS
    {
        func1_AI_4_FSafeType,
        func1_AI_4_FSafeValue
    }
}

MENU Tab_s_func1_AI_4_batch
{
    LABEL        [menu_ident_batch_info];
    ITEMS
    {
        func1_AI_4_batch_id,
        func1_AI_4_batch_unit,
        func1_AI_4_batch_operation,
        func1_AI_4_batch_phase
    }
}

/*---------------------------------------------------------------------*/
/*    AI-4 : (Table - Maintenance)                                     */
/*---------------------------------------------------------------------*/

MENU Tab_m_AI_4
{
    LABEL        "AI-4";
    ITEMS
    {
        func1_AI_4_st_rev,
        Tab_m_AI_4_basic,
        Tab_m_AI_4_advanced
    }
}

MENU Tab_m_AI_4_basic
{
    LABEL        [MC_Tab_basic];
    ITEMS
    {
        Tab_m_AI_4_target_mode,
        Tab_m_AI_4_channel,
        Tab_m_func1_AI_4_pv_range,
        Tab_m_AI_4_outscale,
        Tab_m_AI_4_filter
    }
}

MENU Tab_m_AI_4_target_mode
{
    LABEL        [MC_Tab_mode_ai];
    ITEMS
    {
        func1_AI_4_target_mode    (READ_ONLY)
    }
}

MENU Tab_m_AI_4_channel
{
    LABEL        [MC_Tab_channel];
    ITEMS
    {
        func1_AI_4_channel        (READ_ONLY)
    }
}

MENU Tab_m_func1_AI_4_pv_range
{
    LABEL        [menu_input_measwindow];
    ITEMS
    {
        func1_AI_4_pv_lower_range_value   (READ_ONLY),
        func1_AI_4_pv_upper_range_value   (READ_ONLY)
    }
}

MENU Tab_m_AI_4_outscale
{
    LABEL        [MC_Tab_outscale_ai];
    ITEMS
    {
        func1_AI_4_out_lower_range_value  (READ_ONLY),
        func1_AI_4_out_upper_range_value  (READ_ONLY),
        func1_AI_4_out_unit               (READ_ONLY),
        func1_AI_4_out_decimal_point
    }
}

MENU Tab_m_AI_4_filter
{
    LABEL        [MC_Tab_filter_ai];
    ITEMS
    {
        func1_AI_4_pv_ftime           (READ_ONLY)
    }
}

MENU Tab_m_AI_4_advanced
{
    LABEL        [MC_Tab_advanced];
    ITEMS
    {
        Tab_m_func1_AI_4_limits,
        Tab_m_func1_AI_4_FSafe,
        Tab_m_func1_AI_4_batch
    }
}

MENU Tab_m_func1_AI_4_limits
{
    LABEL        [menu_output_limits];
    ITEMS
    {
        func1_AI_4_lo_lo_lim  (READ_ONLY),
        func1_AI_4_lo_lim     (READ_ONLY),
        func1_AI_4_hi_lim     (READ_ONLY),
        func1_AI_4_hi_hi_lim  (READ_ONLY),
        func1_AI_4_alarm_hys  (READ_ONLY)
    }
}

MENU Tab_m_func1_AI_4_FSafe
{
    LABEL        [menu_fail_safe];
    ITEMS
    {
        func1_AI_4_FSafeType  (READ_ONLY),
        func1_AI_4_FSafeValue (READ_ONLY)
    }
}

MENU Tab_m_func1_AI_4_batch
{
    LABEL        [menu_ident_batch_info];
    ITEMS
    {
        func1_AI_4_batch_id,
        func1_AI_4_batch_unit,
        func1_AI_4_batch_operation,
        func1_AI_4_batch_phase
    }
}

/*---------------------------------------------------------------------*/
/*    AI-4 : Online-Windows                                            */
/*---------------------------------------------------------------------*/

MENU Page_display_func1_AI_4
{
    LABEL        "AI-4";
    ITEMS
    {
        BarVal_display_func1_AI_4,
        Group_display_func1_AI_4_output,
        Group_display_func1_AI_4_input
    }
}

MENU BarVal_display_func1_AI_4
{
    LABEL        [MC_Output_Value];
    ITEMS
    {
        func1_AI_4_out_value                  (READ_ONLY),
        func1_AI_4_out_lower_range_value      (READ_ONLY),
        func1_AI_4_out_upper_range_value      (READ_ONLY)
    }
}

MENU Group_display_func1_AI_4_output
{
    LABEL        [MC_Output];
    ITEMS
    {
        func1_AI_4_actual_mode,
        COLUMNBREAK,
        func1_AI_4_out_status_quality         (READ_ONLY),
        func1_AI_4_out_status_limit           (READ_ONLY),
        func1_AI_4_current_state_alarm_sum
    }
}

MENU Group_display_func1_AI_4_input
{
    LABEL        [MC_Input];
    ITEMS
    {
        func1_AI_4_channel                (READ_ONLY),
        COLUMNBREAK,
        func1_AI_4_simulation_enabled     (READ_ONLY)
    }
}

MENU OnlineWindow_S_alarm_func1_AI_4
{
    LABEL        "AI-4";
    ITEMS
    {
        Page_overview_func1_AI_4,
        Page_alarm_sum_func1_AI_4,
        Page_upper_limit_alarm_func1_AI_4,
        Page_upper_limit_warning_func1_AI_4,
        Page_lower_limit_warning_func1_AI_4,
        Page_lower_limit_alarm_func1_AI_4
    }
}

MENU Page_overview_func1_AI_4
{
    LABEL        [menu_dialog_overview];
    ITEMS
    {
        func1_AI_4_hi_hi_lim          (READ_ONLY),
        func1_AI_4_hi_lim             (READ_ONLY),
        func1_AI_4_lo_lim             (READ_ONLY),
        func1_AI_4_lo_lo_lim          (READ_ONLY),
        COLUMNBREAK,
        func1_AI_4_hi_hi_alm_state    (NO_LABEL),
        func1_AI_4_hi_alm_state       (NO_LABEL),
        func1_AI_4_lo_alm_state       (NO_LABEL),
        func1_AI_4_lo_lo_alm_state    (NO_LABEL),
        COLUMNBREAK,
        func1_AI_4_hi_hi_alm_value    (NO_LABEL),
        func1_AI_4_hi_alm_value       (NO_LABEL),
        func1_AI_4_lo_alm_value       (NO_LABEL),
        func1_AI_4_lo_lo_alm_value    (NO_LABEL)
    }
}

MENU Page_alarm_sum_func1_AI_4
{
    LABEL        [menu_dialog_alarm_sum];
    ITEMS
    {
        func1_AI_4_current_state_alarm_sum,
        func1_AI_4_unacknowledged_state_alarm_sum,
        COLUMNBREAK,
        func1_AI_4_unreported_state_alarm_sum,
        func1_AI_4_disabled_state_alarm_sum
    }
}

MENU Page_upper_limit_alarm_func1_AI_4
{
    LABEL        [limit_hi_hi];
    ITEMS
    {
        func1_AI_4_hi_hi_alm_unacknowledged,
        func1_AI_4_hi_hi_alm_state,
        func1_AI_4_hi_hi_alm_subcode,
        func1_AI_4_hi_hi_lim          (READ_ONLY),
        func1_AI_4_hi_hi_alm_value
    }
}

MENU Page_upper_limit_warning_func1_AI_4
{
    LABEL        [limit_hi];
    ITEMS
    {
        func1_AI_4_hi_alm_unacknowledged,
        func1_AI_4_hi_alm_state,
        func1_AI_4_hi_alm_subcode,
        func1_AI_4_hi_lim          (READ_ONLY),
        func1_AI_4_hi_alm_value
    }
}

MENU Page_lower_limit_warning_func1_AI_4
{
    LABEL        [limit_lo];
    ITEMS
    {
        func1_AI_4_lo_alm_unacknowledged,
        func1_AI_4_lo_alm_state,
        func1_AI_4_lo_alm_subcode,
        func1_AI_4_lo_lim          (READ_ONLY),
        func1_AI_4_lo_alm_value
    }
}

MENU Page_lower_limit_alarm_func1_AI_4
{
    LABEL        [limit_lo_lo];
    ITEMS
    {
        func1_AI_4_lo_lo_alm_unacknowledged,
        func1_AI_4_lo_lo_alm_state,
        func1_AI_4_lo_lo_alm_subcode,
        func1_AI_4_lo_lo_lim          (READ_ONLY),
        func1_AI_4_lo_lo_alm_value
    }
}

MENU Page_diagnosis_func1_AI_4
{
    LABEL        "AI-4";
    ITEMS
    {
        func1_AI_4_blk_object,
        func1_AI_4_blk_parent_class,
        func1_AI_4_blk_class,
        func1_AI_4_blk_dd_reference,
        func1_AI_4_blk_dd_rev,
        func1_AI_4_blk_profile,
        func1_AI_4_blk_profile_rev,
        func1_AI_4_st_rev,
        func1_AI_4_actual_mode,
        func1_AI_4_simulation_enabled (READ_ONLY)
    }
}

/*---------------------------------------------------------------------*/
/*    AI-4 : Online-Dialogs                                            */
/*---------------------------------------------------------------------*/

MENU OnlineDialog_simulation_AI_4
{
	LABEL		"Simulate AI-4";
	ITEMS
	{
		Page_simulation_input_func1_AI_4,
		Page_simulation_output_func1_AI_4
	}
}

MENU Page_simulation_input_func1_AI_4
{
    LABEL        "AI4 Simulation (Measured Value)";
    ITEMS
    {
        func1_AI_4_simulation_enabled,
        Group_simulate_input_func1_AI_4
    }
}

MENU Group_simulate_input_func1_AI_4
{
    LABEL        [func_simulate_value];
    ITEMS
    {
        func1_AI_4_simulate_value,
        COLUMNBREAK,
        func1_AI_4_simulate_status_quality,
        func1_AI_4_simulate_status_limit
    }
}

MENU Page_simulation_output_func1_AI_4
{
    LABEL        "AI4 Simulation (Output)";
    ITEMS
    {
        func1_AI_4_target_mode,
        func1_AI_4_actual_mode,
        Group_simulate_output_func1_AI_4
    }
    POST_EDIT_ACTIONS
    {
        method_AI_4_target_mode
    }
}

MENU Group_simulate_output_func1_AI_4
{
    LABEL        [func_out_value];
    ITEMS
    {

        func1_AI_4_out_value,
        COLUMNBREAK,
        func1_AI_4_out_status_quality,
        func1_AI_4_out_status_limit
    }
}

MENU OnlineDialog_AI_4_setting
{
    LABEL "AI-4 Block Mode";
    ITEMS
    {
        Page_func1_AI_4_mode
    }
}

MENU Page_func1_AI_4_mode
{
    LABEL [MC_Config_Block_Mode];
    ITEMS
    {
        Group_AI_4_mode,
        Group_AI_4_out_value,
        func1_AI_4_current_state_alarm_sum,
        method_set
    }
    POST_EDIT_ACTIONS
    {
        method_AI_4_target_mode
    }
}

MENU Group_AI_4_mode
{
    LABEL [MC_Select_Block_Mode];
    ITEMS
    {
        func1_AI_4_target_mode,
        COLUMNBREAK,
        func1_AI_4_actual_mode
    }
    POST_EDIT_ACTIONS
    {
        method_AI_4_target_mode
    }
}

MENU Group_AI_4_out_value
{
    LABEL [MC_Output];
    ITEMS
    {
        func1_AI_4_out_value,
        COLUMNBREAK,
        func1_AI_4_out_status_quality,
        func1_AI_4_out_status_limit
    }
}

/*---------------------------------------------------------------------*/
/*    AI-4 : Offline-Windows                                           */
/*---------------------------------------------------------------------*/

MENU OfflineWindow_AI_4_geral
{
    LABEL "AI-4";
    ITEMS
    {
        Page_AI_4_Basic_Settings,
        Page_AI_4_Advanced_Settings,
        Page_AI_4_Batch_Info
    }
}

MENU Page_AI_4_Basic_Settings
{
    LABEL [MC_Tab_basic];
    ITEMS
    {
        Group_AI_4_Select_Input,
        Group_AI_4_Process_Value_Scale,
        Group_AI_4_Output_Scale_Unit,
        Group_AI_4_Set_filter_Time
    }
}

MENU Group_AI_4_Select_Input
{
    LABEL [MC_Tab_channel];
    ITEMS
    {
        func1_AI_4_channel,
        COLUMNBREAK,
        method_write_func1_AI_4_channel
    }
}

MENU Group_AI_4_Process_Value_Scale
{
    LABEL [MC_Process_Value_Scale];
    ITEMS
    {
        func1_AI_4_pv_lower_range_value,
        func1_AI_4_pv_upper_range_value,
        COLUMNBREAK,
        method_write_func1_AI_4_pv
    }
}

MENU Group_AI_4_Output_Scale_Unit
{
    LABEL [MC_Tab_outscale_ai];
    ITEMS
    {
        func1_AI_4_out_lower_range_value,
        func1_AI_4_out_upper_range_value,
        func1_AI_4_out_unit,
        func1_AI_4_out_decimal_point,
        COLUMNBREAK,
        method_write_func1_AI_4_out_scale
    }
}

MENU Group_AI_4_Set_filter_Time
{
    LABEL [MC_Tab_filter_ai];
    ITEMS
    {
        func1_AI_4_pv_ftime,
        COLUMNBREAK,
        method_write_func1_AI_4_pv_ftime
    }
}

MENU Page_AI_4_Advanced_Settings
{
    LABEL [MC_Tab_advanced];
    ITEMS
    {
        Group_AI_4_Set_Alarm_Warning_Limits,
        Group_AI_4_Set_Fail_Safe_Values
    }
}

MENU Group_AI_4_Set_Alarm_Warning_Limits
{
    LABEL [MC_Set_Alarm_Warning_Limits];
    ITEMS
    {
        func1_AI_4_lo_lo_lim,
        func1_AI_4_lo_lim,
        func1_AI_4_hi_lim,
        func1_AI_4_hi_hi_lim,
        func1_AI_4_alarm_hys,
        func1_AI_4_out_unit  (READ_ONLY)
        COLUMNBREAK,
        method_write_AI_4_Set_Alarm_Warning_Limits
    }
}

MENU Group_AI_4_Set_Fail_Safe_Values
{
    LABEL [MC_Set_Fail_Safe_Values];
    ITEMS
    {
        func1_AI_4_FSafeType,
        func1_AI_4_FSafeValue
        COLUMNBREAK,
        method_write_AI_4_Set_Fail_Safe_Values
    }
}

MENU Page_AI_4_Batch_Info
{
    LABEL [MC_Batch_Info];
    ITEMS
    {
        Group_AI_4_Define_Batch_Information
    }
}

MENU Group_AI_4_Define_Batch_Information
{
    LABEL [MC_Define_Batch_Info];
    ITEMS
    {
        func1_AI_4_batch_id,
        func1_AI_4_batch_unit,
        func1_AI_4_batch_operation,
        func1_AI_4_batch_phase
        COLUMNBREAK,
        method_write_func1_AI_4_batch_information
    }
}


/*---------------------------------------------------------------------*/
/*    AI-4 : Methods                                                   */
/*---------------------------------------------------------------------*/

METHOD method_AI_4_target_mode
{
    LABEL [MC_method_target_mode];
    DEFINITION
    {
        WriteCommand (write_func1_AI_4_target_mode);
    }
}

METHOD method_write_func1_AI_4_channel
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_4_channel);
        ReadCommand(read_func1_AI_4_channel);
    }
}

METHOD method_write_func1_AI_4_pv
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_4_pv);
        ReadCommand(read_func1_AI_4_pv);
    }
}

METHOD method_write_func1_AI_4_out_scale
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_4_out_scale);
        ReadCommand(read_func1_AI_4_out_scale);
    }
}

METHOD method_write_func1_AI_4_pv_ftime
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_4_pv_ftime);
        ReadCommand(read_func1_AI_4_pv_ftime);
    }
}

METHOD method_write_AI_4_Set_Alarm_Warning_Limits
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_4_lo_lo_lim);
        WriteCommand(write_func1_AI_4_lo_lim);
        WriteCommand(write_func1_AI_4_hi_lim);
        WriteCommand(write_func1_AI_4_hi_hi_lim);
        WriteCommand(write_func1_AI_4_alarm_hys);
        ReadCommand(read_func1_AI_4_lo_lo_lim);
        ReadCommand(read_func1_AI_4_lo_lim);
        ReadCommand(read_func1_AI_4_hi_lim);
        ReadCommand(read_func1_AI_4_hi_hi_lim);
        ReadCommand(read_func1_AI_4_alarm_hys);
    }
}

METHOD method_write_AI_4_Set_Fail_Safe_Values
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_4_FSafeType);
        WriteCommand(write_func1_AI_4_FSafeValue);
        ReadCommand(read_func1_AI_4_FSafeType);
        ReadCommand(read_func1_AI_4_FSafeValue);
    }
}

METHOD method_write_func1_AI_4_batch_information
{
    LABEL [MC_Write];
    DEFINITION
    {
        WriteCommand(write_func1_AI_4_batch_information);
        ReadCommand(read_func1_AI_4_batch_information);
    }
}

/***********************************************************************/
/*    ALL AI Function Block : MENUs                                    */
/***********************************************************************/

MENU Menu_AI_off
{
	LABEL "Analog Input";
	ITEMS
	{
		OfflineWindow_AI_1_geral,
		OfflineWindow_AI_2_geral,
		OfflineWindow_AI_3_geral,
		OfflineWindow_AI_4_geral
	}
}

MENU Menu_AI_on
{
	LABEL "Analog Input";
	ITEMS
	{
		OnlineDialog_AI_1_setting,
		OnlineDialog_AI_2_setting,
		OnlineDialog_AI_3_setting,
		OnlineDialog_AI_4_setting
	}
}

MENU Menu_simulate_AI
{
	LABEL "Simulate-AI";
	ITEMS
	{
		OnlineDialog_simulation_AI_1,
		OnlineDialog_simulation_AI_2,
		OnlineDialog_simulation_AI_3,
		OnlineDialog_simulation_AI_4
	}
}
